/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DefaultNodeInfo
implements NodeInfo {
    private final NetworkAddress hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;
    private int configPort;

    @JsonCreator
    public DefaultNodeInfo(@JsonProperty(value="couchApiBase") String viewUri, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports) {
        if (hostname == null) {
            throw new CouchbaseException(new IllegalArgumentException("NodeInfo hostname cannot be null"));
        }
        try {
            this.hostname = NetworkAddress.create(this.trimPort(hostname));
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = this.parseDirectServices(viewUri, ports);
        this.sslServices = new HashMap<ServiceType, Integer>();
    }

    public DefaultNodeInfo(NetworkAddress hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl) {
        if (hostname == null) {
            throw new CouchbaseException(new IllegalArgumentException("NodeInfo hostname cannot be null"));
        }
        this.hostname = hostname;
        this.directServices = direct;
        this.sslServices = ssl;
    }

    @Override
    public NetworkAddress hostname() {
        return this.hostname;
    }

    @Override
    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    @Override
    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    private Map<ServiceType, Integer> parseDirectServices(String viewUri, Map<String, Integer> input) {
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String type = entry.getKey();
            Integer port = entry.getValue();
            if (!type.equals("direct")) continue;
            services.put(ServiceType.BINARY, port);
        }
        services.put(ServiceType.CONFIG, this.configPort);
        if (viewUri != null) {
            services.put(ServiceType.VIEW, URI.create(viewUri).getPort());
        }
        return services;
    }

    private String trimPort(String hostname) {
        String[] parts = hostname.split(":");
        this.configPort = Integer.parseInt(parts[1]);
        return parts[0];
    }

    public String toString() {
        return "NodeInfo{, hostname=" + this.hostname + ", configPort=" + this.configPort + ", directServices=" + this.directServices + ", sslServices=" + this.sslServices + '}';
    }
}

