/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.connections.Connection;
import org.gcube.documentstore.persistence.connections.Connections;
import org.gcube.documentstore.persistence.connections.Nodes;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceCouchBase
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceCouchBase.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_NAME_PROPERTY_KEY = "bucketName";
    public static final String BUCKET_STORAGE_NAME_PROPERTY_KEY = "AggregatedStorageUsageRecord";
    public static final String BUCKET_STORAGE_TYPE = "StorageUsageRecord";
    public static final String BUCKET_STORAGE_STATUS_NAME_PROPERTY_KEY = "AggregatedStorageStatusRecord";
    public static final String BUCKET_STORAGE_STATUS_TYPE = "StorageStatusRecord";
    public static final String BUCKET_SERVICE_NAME_PROPERTY_KEY = "AggregatedServiceUsageRecord";
    public static final String BUCKET_SERVICE_TYPE = "ServiceUsageRecord";
    public static final String BUCKET_PORTLET_NAME_PROPERTY_KEY = "AggregatedPortletUsageRecord";
    public static final String BUCKET_PORTLET_TYPE = "PortletUsageRecord";
    public static final String BUCKET_JOB_NAME_PROPERTY_KEY = "AggregatedJobUsageRecord";
    public static final String BUCKET_JOB_TYPE = "JobUsageRecord";
    public static final String BUCKET_TASK_NAME_PROPERTY_KEY = "AggregatedTaskUsageRecord";
    public static final String BUCKET_TASK_TYPE = "TaskUsageRecord";
    public static final Integer TIMEOUT_BUCKET = 180;
    public static final Integer ALIVE_INTERVAL = 3600;
    protected Map<String, String> bucketNames;
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(TIMEOUT_BUCKET * 1000).keepAliveInterval(ALIVE_INTERVAL * 1000).build();
    private Nodes nodes;
    private String password;

    @Override
    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        this.password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.nodes = new Nodes(url);
        logger.debug("PersistenceCouchBase prepareConnection url:{} and now is connectionsMap:{}", (Object)url, (Object)Connections.connectionsMap);
        this.bucketNames = new HashMap<String, String>();
        this.bucketNames.put(BUCKET_STORAGE_TYPE, configuration.getProperty(BUCKET_STORAGE_NAME_PROPERTY_KEY));
        this.bucketNames.put(BUCKET_STORAGE_STATUS_TYPE, configuration.getProperty(BUCKET_STORAGE_STATUS_NAME_PROPERTY_KEY));
        this.bucketNames.put(BUCKET_SERVICE_TYPE, configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY));
        this.bucketNames.put(BUCKET_JOB_TYPE, configuration.getProperty(BUCKET_JOB_NAME_PROPERTY_KEY));
        this.bucketNames.put(BUCKET_PORTLET_TYPE, configuration.getProperty(BUCKET_PORTLET_NAME_PROPERTY_KEY));
        this.bucketNames.put(BUCKET_TASK_TYPE, configuration.getProperty(BUCKET_TASK_NAME_PROPERTY_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openConnection() throws Exception {
        Map<Nodes, Connection> map = Connections.connectionsMap;
        synchronized (map) {
            if (!Connections.connectionsMap.containsKey(this.nodes)) {
                Cluster cluster = null;
                try {
                    cluster = CouchbaseCluster.create(ENV, this.nodes.getNodes());
                    Connections.connectionsMap.put(this.nodes, new Connection(cluster));
                    logger.trace("PersistenceCouchBase openConnection insert nodes:{}", (Object)Connections.connectionsMap);
                }
                catch (Exception e) {
                    cluster.disconnect();
                    logger.error("Bucket connection error", e);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bucket getBucketConnection(String recordType) {
        Bucket bucket = null;
        Map<Nodes, Connection> map = Connections.connectionsMap;
        synchronized (map) {
            bucket = Connections.connectionsMap.get(this.nodes).getBucketsMap().get(this.bucketNames.get(recordType));
            try {
                if (bucket == null) {
                    bucket = Connections.connectionsMap.get(this.nodes).getCluster().openBucket(this.bucketNames.get(recordType), this.password);
                    logger.trace("PersistenceCouchBase getBucketConnection bucket close, open:{}", (Object)bucket.toString());
                    Connections.connectionsMap.get(this.nodes).getBucketsMap().put(this.bucketNames.get(recordType), bucket);
                    logger.trace("PersistenceCouchBase getBucketConnection connectionMap:{}", (Object)Connections.connectionsMap.get(this.nodes).getBucketsMap());
                }
            }
            catch (Exception e) {
                logger.error("getBucketConnection connection error", e);
                throw e;
            }
        }
        return bucket;
    }

    protected JsonDocument createItem(JsonObject jsonObject, String id, String recordType) throws Exception {
        JsonDocument doc = JsonDocument.create(id, jsonObject);
        return this.getBucketConnection(recordType).upsert(doc);
    }

    public static JsonNode usageRecordToJsonNode(Record record) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Object node = mapper.valueToTree(record.getResourceProperties());
        return node;
    }

    public static Record jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map result = mapper.convertValue((Object)jsonNode, Map.class);
        Record record = RecordUtility.getRecord(result);
        return record;
    }

    @Override
    protected void reallyAccount(Record record) throws Exception {
        JsonNode node = PersistenceCouchBase.usageRecordToJsonNode(record);
        JsonObject jsonObject = JsonObject.fromJson(node.toString());
        String recordType = record.getRecordType();
        this.createItem(jsonObject, record.getId(), recordType);
    }

    @Override
    public void close() throws Exception {
        logger.trace("PersistenceCouchBase close");
    }

    @Override
    public boolean isConnectionActive() throws Exception {
        return !Connections.connectionsMap.get(this.nodes).getBucketsMap().get(BUCKET_SERVICE_NAME_PROPERTY_KEY).isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAndClean() throws Exception {
        Map<Nodes, Connection> map = Connections.connectionsMap;
        synchronized (map) {
            try {
                if (!Connections.connectionsMap.isEmpty()) {
                    for (Map.Entry<String, Bucket> entry : Connections.connectionsMap.get(this.nodes).getBucketsMap().entrySet()) {
                        Boolean closed = entry.getValue().close();
                        if (closed.booleanValue()) continue;
                        logger.warn("bucket not close :{}", (Object)entry.getKey());
                    }
                    Boolean clusterClosed = Connections.connectionsMap.get(this.nodes).getCluster().disconnect();
                    if (!clusterClosed.booleanValue()) {
                        logger.warn("cluster not disconnect");
                    }
                    Connections.connectionsMap.remove(this.nodes);
                    logger.trace("PersistenceCouchBase disconnect");
                } else {
                    logger.warn("cluster not open");
                }
            }
            catch (Exception e) {
                logger.error("closeAndClean error with close and clean", e);
                throw e;
            }
        }
    }

    @Override
    protected void closeConnection() throws Exception {
        logger.trace("PersistenceCouchBase closeConnection");
    }
}

