/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.util.Blocking;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.DefaultAsyncViewResult;
import com.couchbase.client.java.view.DefaultViewRow;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class DefaultViewResult
implements ViewResult {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private AsyncViewResult asyncViewResult;
    private final long timeout;
    private final CouchbaseEnvironment env;
    private final Bucket bucket;

    public DefaultViewResult(CouchbaseEnvironment env, Bucket bucket, Observable<AsyncViewRow> rows, int totalRows, boolean success, Observable<JsonObject> error, JsonObject debug) {
        this.asyncViewResult = new DefaultAsyncViewResult(rows, totalRows, success, error, debug);
        this.timeout = env.viewTimeout();
        this.env = env;
        this.bucket = bucket;
    }

    @Override
    public List<ViewRow> allRows() {
        return this.allRows(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<ViewRow> allRows(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncViewResult.rows().map(new Func1<AsyncViewRow, ViewRow>(){

            @Override
            public ViewRow call(AsyncViewRow asyncViewRow) {
                return new DefaultViewRow(DefaultViewResult.this.env, asyncViewRow);
            }
        }).toList(), timeout, timeUnit);
    }

    @Override
    public Iterator<ViewRow> rows() {
        return this.rows(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Iterator<ViewRow> rows(long timeout, TimeUnit timeUnit) {
        return this.asyncViewResult.rows().map(new Func1<AsyncViewRow, ViewRow>(){

            @Override
            public ViewRow call(AsyncViewRow asyncViewRow) {
                return new DefaultViewRow(DefaultViewResult.this.env, asyncViewRow);
            }
        }).timeout(timeout, timeUnit).toBlocking().getIterator();
    }

    @Override
    public Iterator<ViewRow> iterator() {
        return this.rows();
    }

    @Override
    public int totalRows() {
        return this.asyncViewResult.totalRows();
    }

    @Override
    public boolean success() {
        return this.asyncViewResult.success();
    }

    @Override
    public JsonObject error() {
        return this.error(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonObject error(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncViewResult.error(), timeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonObject debug() {
        return this.asyncViewResult.debug();
    }
}

