/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.PrelocatedRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.MathUtils;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;

public class QueryLocator
implements Locator {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(QueryLocator.class);
    private volatile long counter = 0L;

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        int offset;
        Node node;
        if ((nodes = this.filterNodes(nodes)).isEmpty()) {
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        if (request instanceof PrelocatedRequest && ((PrelocatedRequest)request).sendTo() != null) {
            NetworkAddress target = NetworkAddress.create(((PrelocatedRequest)request).sendTo().getHostAddress());
            for (Node node2 : nodes) {
                if (!node2.hostname().equals(target)) continue;
                node2.send(request);
                return;
            }
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        int nodeSize = nodes.size();
        if ((node = nodes.get(offset = (int)MathUtils.floorMod(this.counter++, nodeSize))) != null) {
            node.send(request);
        } else {
            LOGGER.warn("Locator found selected node to be null, this is a bug. {}, {}", (Object)request, (Object)nodes);
            RetryHelper.retryOrCancel(env, request, responseBuffer);
        }
    }

    private List<Node> filterNodes(List<Node> allNodes) {
        ArrayList<Node> result = new ArrayList<Node>(allNodes.size());
        for (Node n : allNodes) {
            if (!this.checkNode(n)) continue;
            result.add(n);
        }
        return result;
    }

    protected boolean checkNode(Node node) {
        return node.serviceEnabled(ServiceType.QUERY);
    }
}

