/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceBackendMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendMonitor.class);
    private static final String ELABORATION_FILE_SUFFIX = ".ELABORATION";
    private static final String ELABORATION_FILE_NOT_DELETED_SUFFIX = ".ELABORATION.NOT-DELETED";
    protected final PersistenceBackend persistenceBackend;
    public static final int INITIAL_DELAY = 1;
    public static final int DELAY = 10;
    public static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;

    public PersistenceBackendMonitor(PersistenceBackend persistenceBackend) {
        this.persistenceBackend = persistenceBackend;
        ExecutorUtils.scheduler.scheduleAtFixedRate(this, 1L, 10L, TimeUnit.MINUTES);
    }

    public PersistenceBackendMonitor(PersistenceBackend persistenceBackend, boolean schedule) {
        this.persistenceBackend = persistenceBackend;
        if (schedule) {
            ExecutorUtils.scheduler.scheduleAtFixedRate(this, 1L, 10L, TimeUnit.MINUTES);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void elaborateFile(File elaborationFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(elaborationFile));){
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    Record record = RecordUtility.getRecord(line);
                    this.persistenceBackend.accountWithFallback(record);
                }
                catch (Exception e) {
                    logger.error("Was not possible parse line {} to obtain a valid Record. Going to writing back this line as string fallback file.", (Object)line, (Object)e);
                    FallbackPersistenceBackend fallbackPersistenceBackend = this.persistenceBackend.getFallbackPersistence();
                    try {
                        fallbackPersistenceBackend.printLine(line);
                    }
                    catch (Exception e1) {
                        logger.error("Line {} will be lost", (Object)line, (Object)e1);
                    }
                }
            }
            return;
        }
        catch (FileNotFoundException e) {
            logger.error("File non trovato", e);
            return;
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    @Deprecated
    protected void manageOldAccountingFile() {
        FallbackPersistenceBackend fallbackPersistenceBackend = this.persistenceBackend.getFallbackPersistence();
        File newFile = fallbackPersistenceBackend.getFallbackFile();
        String oldAccountingFileName = newFile.getName();
        int lastIndexOf_ = oldAccountingFileName.lastIndexOf("_");
        oldAccountingFileName = oldAccountingFileName.substring(lastIndexOf_ + 1);
        oldAccountingFileName = oldAccountingFileName.replace("fallback.log", "accountingFallback.log");
        File oldAccountingFile = new File(newFile.getParentFile(), oldAccountingFileName);
        this.elaborateFallbackFile(oldAccountingFile);
    }

    protected synchronized void elaborateFallbackFile(File file) {
        logger.trace("Trying to persist {}s which failed and were persisted using fallback on file {}", (Object)Record.class.getSimpleName(), (Object)file.getAbsoluteFile());
        File elaborationFile = null;
        if (file.exists()) {
            Long timestamp = Calendar.getInstance().getTimeInMillis();
            elaborationFile = new File(file.getAbsolutePath() + ELABORATION_FILE_SUFFIX + "." + timestamp.toString());
            logger.trace("Going to move fallaback file ({}) to elaboration file ({})", (Object)file.getAbsolutePath(), (Object)elaborationFile.getAbsolutePath());
            file.renameTo(elaborationFile);
        }
        if (elaborationFile != null) {
            this.elaborateFile(elaborationFile);
            boolean deleted = elaborationFile.delete();
            if (!deleted) {
                logger.trace("Failed to delete file {}", (Object)elaborationFile.getAbsolutePath());
                File elaborationFileNotDeleted = new File(elaborationFile.getAbsolutePath() + ELABORATION_FILE_NOT_DELETED_SUFFIX);
                elaborationFile.renameTo(elaborationFileNotDeleted);
            }
        }
    }

    @Override
    public void run() {
        FallbackPersistenceBackend fallbackPersistenceBackend = this.persistenceBackend.getFallbackPersistence();
        File file = new File(fallbackPersistenceBackend.getFallbackFile().getAbsolutePath());
        this.elaborateFallbackFile(file);
        this.manageOldAccountingFile();
    }
}

