/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public class Buffers {
    public static final Action1 BYTE_BUF_RELEASER = new Action1<ByteBuf>(){

        @Override
        public void call(ByteBuf byteBuf) {
            if (byteBuf != null && byteBuf.refCnt() > 0) {
                byteBuf.release();
            }
        }
    };

    public static <T> Observable<T> wrapColdWithAutoRelease(final Observable<T> source) {
        return Observable.create(new Observable.OnSubscribe<T>(){

            @Override
            public void call(final Subscriber<? super T> subscriber) {
                source.subscribe(new Subscriber<T>(){

                    @Override
                    public void onCompleted() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onCompleted();
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onError(e);
                        }
                    }

                    @Override
                    public void onNext(T t) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(t);
                        } else {
                            ReferenceCountUtil.release(t);
                        }
                    }
                });
            }
        });
    }
}

