/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils;

import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observers.Subscribers;
import rx.schedulers.Schedulers;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class UnicastAutoReleaseSubject<T>
extends Subject<T, T> {
    private final State<T> state;
    private volatile Observable<Long> timeoutScheduler;

    private UnicastAutoReleaseSubject(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
        this.timeoutScheduler = Observable.empty();
    }

    private UnicastAutoReleaseSubject(State<T> state, long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler scheduler) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
        this.timeoutScheduler = Observable.interval(noSubscriptionTimeout, timeUnit, scheduler).take(1);
    }

    public static <T> UnicastAutoReleaseSubject<T> createWithoutNoSubscriptionTimeout(Action0 onUnsubscribe) {
        State state = new State(onUnsubscribe);
        return new UnicastAutoReleaseSubject(state);
    }

    public static <T> UnicastAutoReleaseSubject<T> createWithoutNoSubscriptionTimeout() {
        return UnicastAutoReleaseSubject.createWithoutNoSubscriptionTimeout(null);
    }

    public static <T> UnicastAutoReleaseSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit) {
        return UnicastAutoReleaseSubject.create(noSubscriptionTimeout, timeUnit, (Action0)null);
    }

    public static <T> UnicastAutoReleaseSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Action0 onUnsubscribe) {
        return UnicastAutoReleaseSubject.create(noSubscriptionTimeout, timeUnit, Schedulers.computation(), onUnsubscribe);
    }

    public static <T> UnicastAutoReleaseSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler) {
        return UnicastAutoReleaseSubject.create(noSubscriptionTimeout, timeUnit, timeoutScheduler, null);
    }

    public static <T> UnicastAutoReleaseSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler, Action0 onUnsubscribe) {
        State state = new State(onUnsubscribe);
        return new UnicastAutoReleaseSubject(state, noSubscriptionTimeout, timeUnit, timeoutScheduler);
    }

    public UnicastAutoReleaseSubject<T> withTraceIdentifier(String id) {
        ((State)this.state).traceId = id;
        return this;
    }

    public boolean disposeIfNotSubscribed() {
        if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.DISPOSED)) {
            ((State)this.state).bufferedSubject.lift(new AutoReleaseByteBufOperator()).subscribe(Subscribers.empty());
            return true;
        }
        return false;
    }

    @Override
    public void onCompleted() {
        ((State)this.state).bufferedSubject.onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        ((State)this.state).bufferedSubject.onError(e);
    }

    @Override
    public void onNext(T t) {
        ((State)this.state).bufferedSubject.onNext(t);
        if (this.state.casTimeoutScheduled() && ((State)this.state).state == State.STATES.UNSUBSCRIBED.ordinal()) {
            this.state.setTimeoutSubscription(this.timeoutScheduler.subscribe(new Action1<Long>(){

                @Override
                public void call(Long aLong) {
                    UnicastAutoReleaseSubject.this.disposeIfNotSubscribed();
                }
            }));
        }
    }

    @Override
    public boolean hasObservers() {
        return ((State)this.state).state == State.STATES.SUBSCRIBED.ordinal();
    }

    private static class AutoReleaseByteBufOperator<I>
    implements Observable.Operator<I, I> {
        private AutoReleaseByteBufOperator() {
        }

        @Override
        public Subscriber<? super I> call(final Subscriber<? super I> subscriber) {
            return new Subscriber<I>(){

                @Override
                public void onCompleted() {
                    subscriber.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    subscriber.onError(e);
                }

                @Override
                public void onNext(I t) {
                    try {
                        subscriber.onNext(t);
                    }
                    finally {
                        ReferenceCountUtil.release(t);
                    }
                }
            };
        }
    }

    private static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        private final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        @Override
        public void call(Subscriber<? super T> subscriber) {
            if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.SUBSCRIBED)) {
                subscriber.add(Subscriptions.create(new Action0(){

                    @Override
                    public void call() {
                        if (null != OnSubscribeAction.this.state.onUnsubscribe) {
                            OnSubscribeAction.this.state.onUnsubscribe.call();
                        }
                    }
                }));
                ((State)this.state).bufferedSubject.subscribe(subscriber);
                this.state.unsubscribeTimeoutSubscription();
            } else if (State.STATES.SUBSCRIBED.ordinal() == ((State)this.state).state) {
                String thisObservable = "This Observable ";
                if (((State)this.state).traceId != null) {
                    thisObservable = "This Observable (" + ((State)this.state).traceId + ") ";
                }
                subscriber.onError(new IllegalStateException(thisObservable + "can only have one subscription. " + "Use Observable.publish() if you want to multicast."));
            } else if (State.STATES.DISPOSED.ordinal() == ((State)this.state).state) {
                String thisObservable = "The content of this Observable ";
                if (((State)this.state).traceId != null) {
                    thisObservable = "The content of this Observable (" + ((State)this.state).traceId + ") ";
                }
                subscriber.onError(new IllegalStateException(thisObservable + "is already released. " + "Subscribe earlier or tune the CouchbaseEnvironment#autoreleaseAfter() setting."));
            }
        }
    }

    private static final class State<T> {
        private String traceId;
        private static final AtomicIntegerFieldUpdater<State> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "state");
        private static final AtomicIntegerFieldUpdater<State> TIMEOUT_SCHEDULED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "timeoutScheduled");
        private final Action0 onUnsubscribe;
        private final Subject<T, T> bufferedSubject;
        private volatile Subscription timeoutSubscription;
        private volatile int timeoutScheduled;
        private volatile int state = STATES.UNSUBSCRIBED.ordinal();

        public State(Action0 onUnsubscribe) {
            this.onUnsubscribe = onUnsubscribe;
            this.bufferedSubject = BufferUntilSubscriber.create();
        }

        public boolean casState(STATES expected, STATES next) {
            return STATE_UPDATER.compareAndSet(this, expected.ordinal(), next.ordinal());
        }

        public boolean casTimeoutScheduled() {
            return TIMEOUT_SCHEDULED_UPDATER.compareAndSet(this, 0, 1);
        }

        public void setTimeoutSubscription(Subscription subscription) {
            this.timeoutSubscription = subscription;
        }

        public void unsubscribeTimeoutSubscription() {
            if (this.timeoutSubscription != null) {
                this.timeoutSubscription.unsubscribe();
            }
        }

        private static enum STATES {
            UNSUBSCRIBED,
            SUBSCRIBED,
            DISPOSED;

        }
    }
}

