/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceCouchBase
extends PersistenceBackend {
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_NAME_PROPERTY_KEY = "bucketName";
    public static final String BUCKET_STORAGE_NAME_PROPERTY_KEY = "AggregatedStorageUsageRecord";
    public static final String BUCKET_STORAGE_TYPE = "StorageUsageRecord";
    public static final String BUCKET_SERVICE_NAME_PROPERTY_KEY = "AggregatedServiceUsageRecord";
    public static final String BUCKET_SERVICE_TYPE = "ServiceUsageRecord";
    public static final String BUCKET_PORTLET_NAME_PROPERTY_KEY = "AggregatedPortletUsageRecord";
    public static final String BUCKET_PORTLET_TYPE = "PortletUsageRecord";
    public static final String BUCKET_JOB_NAME_PROPERTY_KEY = "AggregatedJobUsageRecord";
    public static final String BUCKET_JOB_TYPE = "JobUsageRecord";
    public static final String BUCKET_TASK_NAME_PROPERTY_KEY = "AggregatedTaskUsageRecord";
    public static final String BUCKET_TASK_TYPE = "TaskUsageRecord";
    private static final Logger logger = LoggerFactory.getLogger(PersistenceCouchBase.class);
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(8000L).keepAliveInterval(3600000L).build();
    protected Cluster cluster;
    protected Bucket bucketStorage;
    protected String bucketNameStorage;
    protected Bucket bucketService;
    protected String bucketNameService;
    protected Bucket bucketPortlet;
    protected String bucketNamePortlet;
    protected Bucket bucketJob;
    protected String bucketNameJob;
    protected Bucket bucketTask;
    protected String bucketNameTask;
    private Map<String, Bucket> connectionMap;

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        logger.trace("cluster: {}", (Object)url);
        this.bucketNameStorage = configuration.getProperty(BUCKET_STORAGE_NAME_PROPERTY_KEY);
        this.bucketNameService = configuration.getProperty(BUCKET_SERVICE_NAME_PROPERTY_KEY);
        this.bucketNameJob = configuration.getProperty(BUCKET_JOB_NAME_PROPERTY_KEY);
        this.bucketNamePortlet = configuration.getProperty(BUCKET_PORTLET_NAME_PROPERTY_KEY);
        this.bucketNameTask = configuration.getProperty(BUCKET_TASK_NAME_PROPERTY_KEY);
        this.connectionMap = new HashMap<String, Bucket>();
        this.bucketStorage = this.cluster.openBucket(this.bucketNameStorage, password);
        this.connectionMap.put(BUCKET_STORAGE_TYPE, this.bucketStorage);
        logger.trace("open bucket: {} with {}", (Object)this.bucketNameStorage, (Object)BUCKET_STORAGE_TYPE);
        this.bucketService = this.cluster.openBucket(this.bucketNameService, password);
        this.connectionMap.put(BUCKET_SERVICE_TYPE, this.bucketService);
        logger.trace("open bucket: {} with {}", (Object)this.bucketNameService, (Object)BUCKET_SERVICE_TYPE);
        this.bucketJob = this.cluster.openBucket(this.bucketNameJob, password);
        this.connectionMap.put(BUCKET_JOB_TYPE, this.bucketJob);
        logger.trace("open bucket: {} with {}", (Object)this.bucketNameJob, (Object)BUCKET_JOB_TYPE);
        this.bucketPortlet = this.cluster.openBucket(this.bucketNamePortlet, password);
        this.connectionMap.put(BUCKET_PORTLET_TYPE, this.bucketPortlet);
        logger.trace("open bucket: {} with {}", (Object)this.bucketNamePortlet, (Object)BUCKET_PORTLET_TYPE);
        this.bucketTask = this.cluster.openBucket(this.bucketNameTask, password);
        this.connectionMap.put(BUCKET_TASK_TYPE, this.bucketTask);
        logger.trace("open bucket: {} with {}", (Object)this.bucketNameTask, (Object)BUCKET_TASK_TYPE);
    }

    protected JsonDocument createItem(JsonObject jsonObject, String id, String recordType) throws Exception {
        JsonDocument doc = JsonDocument.create((String)id, (JsonObject)jsonObject);
        logger.trace("record type:{} accounting on:{}", (Object)recordType, (Object)this.connectionMap.get(recordType).toString());
        return (JsonDocument)this.connectionMap.get(recordType).upsert((Document)doc);
    }

    public static JsonNode usageRecordToJsonNode(Record record) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.valueToTree((Object)record.getResourceProperties());
        return node;
    }

    public static Record jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
        Record record = RecordUtility.getRecord((Map)result);
        return record;
    }

    protected void reallyAccount(Record record) throws Exception {
        JsonNode node = PersistenceCouchBase.usageRecordToJsonNode(record);
        JsonObject jsonObject = JsonObject.fromJson((String)node.toString());
        String recordType = record.getRecordType();
        this.createItem(jsonObject, record.getId(), recordType);
    }

    public void close() throws Exception {
        this.cluster.disconnect();
    }
}

