/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.org.HdrHistogram;

import com.couchbase.client.deps.org.HdrHistogram.AbstractHistogram;
import com.couchbase.client.deps.org.HdrHistogram.AbstractHistogramIterator;
import com.couchbase.client.deps.org.HdrHistogram.HistogramIterationValue;
import java.util.Iterator;

public class LinearIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    long valueUnitsPerBucket;
    long nextValueReportingLevel;
    long nextValueReportingLevelLowestEquivalent;

    public void reset(long valueUnitsPerBucket) {
        this.reset(this.histogram, valueUnitsPerBucket);
    }

    private void reset(AbstractHistogram histogram, long valueUnitsPerBucket) {
        super.resetIterator(histogram);
        this.valueUnitsPerBucket = valueUnitsPerBucket;
        this.nextValueReportingLevel = valueUnitsPerBucket;
        this.nextValueReportingLevelLowestEquivalent = histogram.lowestEquivalentValue(this.nextValueReportingLevel);
    }

    public LinearIterator(AbstractHistogram histogram, long valueUnitsPerBucket) {
        this.reset(histogram, valueUnitsPerBucket);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.nextValueReportingLevelLowestEquivalent < this.nextValueAtIndex;
    }

    @Override
    void incrementIterationLevel() {
        this.nextValueReportingLevel += this.valueUnitsPerBucket;
        this.nextValueReportingLevelLowestEquivalent = this.histogram.lowestEquivalentValue(this.nextValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.nextValueReportingLevel;
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.nextValueReportingLevelLowestEquivalent;
    }
}

