/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.org.HdrHistogram;

import com.couchbase.client.deps.org.HdrHistogram.EncodableHistogram;
import com.couchbase.client.deps.org.HdrHistogram.Histogram;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.zip.DataFormatException;
import javax.xml.bind.DatatypeConverter;

class AbstractHistogramLogReader {
    protected final Scanner scanner;
    private double startTimeSec = 0.0;

    public AbstractHistogramLogReader(String inputFileName) throws FileNotFoundException {
        this.scanner = new Scanner(new File(inputFileName));
        this.initScanner();
    }

    public AbstractHistogramLogReader(InputStream inputStream) {
        this.scanner = new Scanner(inputStream);
        this.initScanner();
    }

    public AbstractHistogramLogReader(File inputFile) throws FileNotFoundException {
        this.scanner = new Scanner(inputFile);
        this.initScanner();
    }

    private void initScanner() {
        this.scanner.useLocale(Locale.US);
        this.scanner.useDelimiter("[ ,\\r\\n]");
    }

    public double getStartTimeSec() {
        return this.startTimeSec;
    }

    protected void setStartTimeSec(double startTimeSec) {
        this.startTimeSec = startTimeSec;
    }

    public EncodableHistogram nextIntervalHistogram(Double startTimeSec, Double endTimeSec) {
        return this.nextIntervalHistogram(startTimeSec, endTimeSec, false);
    }

    public EncodableHistogram nextAbsoluteIntervalHistogram(Double absoluteStartTimeSec, Double absoluteEndTimeSec) {
        return this.nextIntervalHistogram(absoluteStartTimeSec, absoluteEndTimeSec, true);
    }

    public EncodableHistogram nextIntervalHistogram() {
        return this.nextIntervalHistogram(0.0, 9.223372036854776E18, true);
    }

    private EncodableHistogram nextIntervalHistogram(Double rangeStartTimeSec, Double rangeEndTimeSec, boolean absolute) {
        while (this.scanner.hasNextLine()) {
            try {
                double startTimeStampToCheckRangeOn;
                if (this.scanner.hasNext("\\#.*")) {
                    if (this.scanner.hasNext("#\\[StartTime:")) {
                        this.scanner.next("#\\[StartTime:");
                        if (this.scanner.hasNextDouble()) {
                            this.setStartTimeSec(this.scanner.nextDouble());
                        }
                    }
                    this.scanner.nextLine();
                    continue;
                }
                if (this.scanner.hasNext("\"StartTimestamp\".*")) {
                    this.scanner.nextLine();
                    continue;
                }
                double offsetStartTimeStampSec = this.scanner.nextDouble();
                double absoluteStartTimeStampSec = this.getStartTimeSec() + offsetStartTimeStampSec;
                double intervalLengthSec = this.scanner.nextDouble();
                double offsetEndTimeStampSec = offsetStartTimeStampSec + intervalLengthSec;
                double absoluteEndTimeStampSec = this.getStartTimeSec() + offsetEndTimeStampSec;
                double d = startTimeStampToCheckRangeOn = absolute ? absoluteStartTimeStampSec : offsetStartTimeStampSec;
                if (startTimeStampToCheckRangeOn < rangeStartTimeSec) {
                    this.scanner.nextLine();
                    continue;
                }
                if (startTimeStampToCheckRangeOn > rangeEndTimeSec) {
                    return null;
                }
                this.scanner.nextDouble();
                String compressedPayloadString = this.scanner.next();
                ByteBuffer buffer = ByteBuffer.wrap(DatatypeConverter.parseBase64Binary((String)compressedPayloadString));
                Histogram histogram = Histogram.decodeFromCompressedByteBuffer(buffer, 0L);
                ((EncodableHistogram)histogram).setStartTimeStamp((long)(absoluteStartTimeStampSec * 1000.0));
                ((EncodableHistogram)histogram).setEndTimeStamp((long)(absoluteEndTimeStampSec * 1000.0));
                return histogram;
            }
            catch (NoSuchElementException ex) {
                return null;
            }
            catch (DataFormatException ex) {
                return null;
            }
        }
        return null;
    }
}

