/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executor;
import rx.Scheduler;
import rx.internal.schedulers.EventLoopsScheduler;
import rx.internal.schedulers.GenericScheduledExecutorService;
import rx.internal.schedulers.SchedulerLifecycle;
import rx.internal.util.RxRingBuffer;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.CachedThreadScheduler;
import rx.schedulers.ExecutorScheduler;
import rx.schedulers.ImmediateScheduler;
import rx.schedulers.NewThreadScheduler;
import rx.schedulers.TestScheduler;
import rx.schedulers.TrampolineScheduler;

public final class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final Schedulers INSTANCE = new Schedulers();

    private Schedulers() {
        Scheduler c = RxJavaPlugins.getInstance().getSchedulersHook().getComputationScheduler();
        this.computationScheduler = c != null ? c : new EventLoopsScheduler();
        Scheduler io = RxJavaPlugins.getInstance().getSchedulersHook().getIOScheduler();
        this.ioScheduler = io != null ? io : new CachedThreadScheduler();
        Scheduler nt = RxJavaPlugins.getInstance().getSchedulersHook().getNewThreadScheduler();
        this.newThreadScheduler = nt != null ? nt : NewThreadScheduler.instance();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.instance();
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.instance();
    }

    public static Scheduler newThread() {
        return Schedulers.INSTANCE.newThreadScheduler;
    }

    public static Scheduler computation() {
        return Schedulers.INSTANCE.computationScheduler;
    }

    public static Scheduler io() {
        return Schedulers.INSTANCE.ioScheduler;
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void start() {
        Schedulers s;
        Schedulers schedulers = s = INSTANCE;
        synchronized (schedulers) {
            if (s.computationScheduler instanceof SchedulerLifecycle) {
                ((SchedulerLifecycle)((Object)s.computationScheduler)).start();
            }
            if (s.ioScheduler instanceof SchedulerLifecycle) {
                ((SchedulerLifecycle)((Object)s.ioScheduler)).start();
            }
            if (s.newThreadScheduler instanceof SchedulerLifecycle) {
                ((SchedulerLifecycle)((Object)s.newThreadScheduler)).start();
            }
            GenericScheduledExecutorService.INSTANCE.start();
            RxRingBuffer.SPSC_POOL.start();
            RxRingBuffer.SPMC_POOL.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Schedulers s;
        Schedulers schedulers = s = INSTANCE;
        synchronized (schedulers) {
            if (s.computationScheduler instanceof SchedulerLifecycle) {
                ((SchedulerLifecycle)((Object)s.computationScheduler)).shutdown();
            }
            if (s.ioScheduler instanceof SchedulerLifecycle) {
                ((SchedulerLifecycle)((Object)s.ioScheduler)).shutdown();
            }
            if (s.newThreadScheduler instanceof SchedulerLifecycle) {
                ((SchedulerLifecycle)((Object)s.newThreadScheduler)).shutdown();
            }
            GenericScheduledExecutorService.INSTANCE.shutdown();
            RxRingBuffer.SPSC_POOL.shutdown();
            RxRingBuffer.SPMC_POOL.shutdown();
        }
    }
}

