/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.Map;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;

public class PersistenceCouchBase
extends PersistenceBackend {
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String BUCKET_NAME_PROPERTY_KEY = "bucketName";
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(8000L).keepAliveInterval(3600000L).build();
    protected Cluster cluster;
    protected Bucket bucket;

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        this.bucket = this.cluster.openBucket(configuration.getProperty(BUCKET_NAME_PROPERTY_KEY), password);
    }

    protected JsonDocument createItem(JsonObject jsonObject, String id) throws Exception {
        JsonDocument doc = JsonDocument.create((String)id, (JsonObject)jsonObject);
        return (JsonDocument)this.bucket.upsert((Document)doc);
    }

    public static JsonNode usageRecordToJsonNode(Record record) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.valueToTree((Object)record.getResourceProperties());
        return node;
    }

    public static Record jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
        Record record = RecordUtility.getRecord((Map)result);
        return record;
    }

    protected void reallyAccount(Record record) throws Exception {
        JsonNode node = PersistenceCouchBase.usageRecordToJsonNode(record);
        JsonObject jsonObject = JsonObject.fromJson((String)node.toString());
        this.createItem(jsonObject, record.getId());
    }

    public void close() throws Exception {
        this.cluster.disconnect();
    }
}

