/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public final class OnSubscribeRange
implements Observable.OnSubscribe<Integer> {
    private final int start;
    private final int end;

    public OnSubscribeRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void call(Subscriber<? super Integer> o) {
        o.setProducer(new RangeProducer(o, this.start, this.end));
    }

    private static final class RangeProducer
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = 4114392207069098388L;
        private final Subscriber<? super Integer> o;
        private final int end;
        private long index;

        private RangeProducer(Subscriber<? super Integer> o, int start, int end) {
            this.o = o;
            this.index = start;
            this.end = end;
        }

        @Override
        public void request(long n) {
            long c;
            if (this.get() == Long.MAX_VALUE) {
                return;
            }
            if (n == Long.MAX_VALUE && this.compareAndSet(0L, Long.MAX_VALUE)) {
                this.fastpath();
            } else if (n > 0L && (c = BackpressureUtils.getAndAddRequest(this, n)) == 0L) {
                this.slowpath(n);
            }
        }

        void slowpath(long r) {
            long e;
            long idx = this.index;
            do {
                long fs = (long)this.end - idx + 1L;
                e = Math.min(fs, r);
                boolean complete = fs <= r;
                fs = e + idx;
                Subscriber<? super Integer> o = this.o;
                for (long i = idx; i != fs; ++i) {
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    o.onNext((Integer)((int)i));
                }
                if (complete) {
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    o.onCompleted();
                    return;
                }
                idx = fs;
                this.index = fs;
            } while ((r = this.addAndGet(-e)) != 0L);
        }

        void fastpath() {
            long end = (long)this.end + 1L;
            Subscriber<? super Integer> o = this.o;
            for (long i = this.index; i != end; ++i) {
                if (o.isUnsubscribed()) {
                    return;
                }
                o.onNext((Integer)((int)i));
            }
            if (!o.isUnsubscribed()) {
                o.onCompleted();
            }
        }
    }
}

