/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.ConfigRequest;
import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.core.node.ServiceRegistry;
import com.couchbase.client.core.service.BucketServiceMapping;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceType;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Map<ServiceType, Service> globalServices;
    private final Map<String, Map<ServiceType, Service>> localServices;
    private volatile Service[] serviceCache;

    DefaultServiceRegistry(Map<ServiceType, Service> globalServices, Map<String, Map<ServiceType, Service>> localServices) {
        this.globalServices = globalServices;
        this.localServices = localServices;
        this.serviceCache = new Service[0];
    }

    public DefaultServiceRegistry() {
        this(new ConcurrentHashMap<ServiceType, Service>(), new ConcurrentHashMap<String, Map<ServiceType, Service>>());
    }

    @Override
    public Service addService(Service service, String bucket) {
        if (service.mapping() == BucketServiceMapping.ONE_BY_ONE) {
            if (!this.localServices.containsKey(bucket)) {
                this.localServices.put(bucket, new ConcurrentHashMap());
            }
            if (!this.localServices.get(bucket).containsKey((Object)service.type())) {
                this.localServices.get(bucket).put(service.type(), service);
            }
        } else if (!this.globalServices.containsKey((Object)service.type())) {
            this.globalServices.put(service.type(), service);
        }
        this.recalculateServiceCache();
        return service;
    }

    @Override
    public Service removeService(Service service, String bucket) {
        if (service.mapping() == BucketServiceMapping.ONE_BY_ONE) {
            if (this.localServices.containsKey(bucket) && this.localServices.get(bucket).containsKey((Object)service.type())) {
                this.localServices.get(bucket).remove((Object)service.type());
            }
            if (this.localServices.get(bucket).isEmpty()) {
                this.localServices.remove(bucket);
            }
        } else if (this.globalServices.containsKey((Object)service.type())) {
            this.globalServices.remove((Object)service.type());
        }
        this.recalculateServiceCache();
        return service;
    }

    @Override
    public Service locate(CouchbaseRequest request) {
        ServiceType type = DefaultServiceRegistry.serviceTypeFor(request);
        if (type.mapping() == BucketServiceMapping.ONE_BY_ONE) {
            Map<ServiceType, Service> services = this.localServices.get(request.bucket());
            if (services == null) {
                return null;
            }
            return services.get((Object)type);
        }
        return this.globalServices.get((Object)type);
    }

    @Override
    public Service[] services() {
        return this.serviceCache;
    }

    private void recalculateServiceCache() {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : this.globalServices.values()) {
            services.add(service);
        }
        for (Map map : this.localServices.values()) {
            for (Service service : map.values()) {
                services.add(service);
            }
        }
        this.serviceCache = services.toArray(new Service[services.size()]);
    }

    @Override
    public Service serviceBy(ServiceType type, String bucket) {
        if (type.mapping() == BucketServiceMapping.ONE_BY_ONE) {
            if (this.localServices.get(bucket) == null) {
                return null;
            }
            return this.localServices.get(bucket).get((Object)type);
        }
        return this.globalServices.get((Object)type);
    }

    private static ServiceType serviceTypeFor(CouchbaseRequest request) {
        if (request instanceof BinaryRequest) {
            return ServiceType.BINARY;
        }
        if (request instanceof ConfigRequest) {
            return ServiceType.CONFIG;
        }
        if (request instanceof ViewRequest) {
            return ServiceType.VIEW;
        }
        if (request instanceof QueryRequest) {
            return ServiceType.QUERY;
        }
        if (request instanceof DCPRequest) {
            return ServiceType.DCP;
        }
        throw new IllegalStateException("Unknown Request: " + request);
    }

    public String toString() {
        return "DefaultServiceRegistry{globalServices=" + this.globalServices + ", localServices=" + this.localServices + ", serviceCache=" + this.serviceCache + '}';
    }
}

