/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.dcp;

import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.utils.UnicastAutoReleaseSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class DCPConnection {
    private static volatile int nextStreamId = 0;
    private final String name;
    private final SerializedSubject<DCPRequest, DCPRequest> subject;
    private final String bucket;
    private volatile int totalReceivedBytes;
    private List<Integer> streams = Collections.synchronizedList(new ArrayList());

    public DCPConnection(CoreEnvironment env, String name, String bucket) {
        this.name = name;
        this.totalReceivedBytes = 0;
        this.bucket = bucket;
        this.subject = UnicastAutoReleaseSubject.create(env.autoreleaseAfter(), TimeUnit.MILLISECONDS, env.scheduler()).toSerialized();
    }

    public int addStream(String connectionName) {
        int streamId = nextStreamId++;
        this.streams.add(streamId);
        return streamId;
    }

    public void removeStream(int streamId) {
        this.streams.remove((Object)streamId);
    }

    public int streamsCount() {
        return this.streams.size();
    }

    public String name() {
        return this.name;
    }

    public String bucket() {
        return this.bucket;
    }

    public Subject<DCPRequest, DCPRequest> subject() {
        return this.subject;
    }

    public int totalReceivedBytes() {
        return this.totalReceivedBytes;
    }

    public void inc(int delta) {
        this.totalReceivedBytes += delta;
    }

    public void reset() {
        this.totalReceivedBytes = 0;
    }
}

