/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.IdentifiableDeserializableModule;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.AbstractRecord;

public class DSMapper {
    protected static final ObjectMapper mapper = new ObjectMapper();

    private DSMapper() {
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <T extends OutputStream, R extends Record> T marshal(R object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, R extends Record> T marshal(R object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <R extends Record> String marshal(R object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <R extends Record> String marshal(List<R> list) throws IOException {
        StringWriter sw = new StringWriter();
        mapper.writeValue(sw, list);
        String ret = sw.toString();
        sw.close();
        return ret;
    }

    public static <R extends Record> R unmarshal(Class<R> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return (R)((Record)mapper.readValue(reader, clz));
    }

    public static <R extends Record> R unmarshal(Class<R> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return (R)((Record)mapper.readValue(stream, clz));
    }

    public static <R extends Record> R unmarshal(Class<R> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (R)((Record)mapper.readValue(string, clz));
    }

    public static <R extends Record> List<R> unmarshalList(Class<R> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    public static <R extends Record> List<R> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Record.class);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    public static <R extends Record> void registerSubtypes(Class<R> ... classes) {
        mapper.registerSubtypes(classes);
    }

    public static JsonNode asJsonNode(String jsonString) throws JsonProcessingException, IOException {
        ObjectMapper mapperJson = new ObjectMapper();
        return mapperJson.readTree(jsonString);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule(new IdentifiableDeserializableModule());
        mapper.registerSubtypes(Record.class);
        mapper.registerSubtypes(AggregatedRecord.class);
        mapper.registerSubtypes(AbstractRecord.class);
    }
}

