/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class CustomMapDeserializer
extends StdDeserializer<Map<String, Serializable>> {
    private static final long serialVersionUID = 1L;

    protected CustomMapDeserializer() {
        super(Map.class);
    }

    @Override
    public Map<String, Serializable> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken currentToken = null;
        HashMap<String, Serializable> toRetunMap = new HashMap<String, Serializable>();
        Stack mapsStack = new Stack();
        block12: while ((currentToken = jp.nextValue()) != null) {
            switch (currentToken) {
                case END_ARRAY: {
                    continue block12;
                }
                case START_ARRAY: {
                    continue block12;
                }
                case START_OBJECT: {
                    mapsStack.push(new HashMap());
                    continue block12;
                }
                case FIELD_NAME: {
                    if (mapsStack.isEmpty()) {
                        toRetunMap.put(jp.getCurrentName(), (Serializable)((Object)jp.getText()));
                        continue block12;
                    }
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), jp.getText());
                    continue block12;
                }
                case VALUE_STRING: {
                    if (mapsStack.isEmpty()) {
                        toRetunMap.put(jp.getCurrentName(), (Serializable)((Object)jp.getText()));
                        continue block12;
                    }
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), jp.getText());
                    continue block12;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (mapsStack.isEmpty()) {
                        toRetunMap.put(jp.getCurrentName(), (Serializable)((Object)jp.getText()));
                        continue block12;
                    }
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), jp.getText());
                    continue block12;
                }
                case VALUE_NUMBER_INT: {
                    if (mapsStack.isEmpty()) {
                        toRetunMap.put(jp.getCurrentName(), (Serializable)((Object)jp.getText()));
                        continue block12;
                    }
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), jp.getText());
                    continue block12;
                }
                case VALUE_FALSE: {
                    if (mapsStack.isEmpty()) {
                        toRetunMap.put(jp.getCurrentName(), Boolean.valueOf(false));
                        continue block12;
                    }
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), false);
                    continue block12;
                }
                case VALUE_TRUE: {
                    if (mapsStack.isEmpty()) {
                        toRetunMap.put(jp.getCurrentName(), Boolean.valueOf(true));
                        continue block12;
                    }
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), true);
                    continue block12;
                }
                case END_OBJECT: {
                    if (mapsStack.isEmpty()) continue block12;
                    if (mapsStack.size() == 1) {
                        toRetunMap.put(jp.getCurrentName(), (Serializable)mapsStack.pop());
                        continue block12;
                    }
                    Map tmpMap = (Map)mapsStack.pop();
                    ((Map)mapsStack.peek()).put(jp.getCurrentName(), (Serializable)((Object)tmpMap));
                    continue block12;
                }
            }
        }
        return toRetunMap;
    }
}

