/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.DataOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBContext;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.SerializableList;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceAccountingService
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceAccountingService.class);
    public static final String URL_SERVICE_ACCOUNTING_KEY = "UrlAccountingService";
    public static final String PATH_SERVICE_ACCOUNTING = "/accounting-service/gcube/service";
    public static final String PATH_SERVICE_INSERT_ACCOUNTING = "/insert/record";
    public static final String PATH_SERVICE_INSERTS_ACCOUNTING = "/insert/records";
    public static final String PATH_SERVICE_STATUS_ACCOUNTING = "insert/getStatus";
    public static final String GCORE_END_POINT_NAME = "AccountService webapp";
    public static final String GCORE_END_RUNNING = "RunningInstance";
    public static final String RESOURCE_ACCOUNTING = "org.gcube.data.publishing.accounting.service.AccountingResource";
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_XML = "application/xml";
    protected String urlService;
    protected String context;

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        try {
            this.context = ScopeProvider.instance.get();
            logger.debug("prepareConnection context:{}", (Object)this.context);
            ScopeProvider.instance.set(this.context);
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition("$resource/Profile/Description/text() eq 'AccountService webapp'");
            query.addCondition("$resource/Type/text() eq 'RunningInstance'");
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List toReturn = client.submit((Query)query);
            GCoreEndpoint endpoint = (GCoreEndpoint)toReturn.get(0);
            GCoreEndpoint.Profile profile = endpoint.profile();
            GCoreEndpoint.Profile.Endpoint url = (GCoreEndpoint.Profile.Endpoint)profile.endpointMap().get(RESOURCE_ACCOUNTING);
            this.urlService = url.uri().toString();
            logger.debug("urlService from GcoreEndPoint:{}", (Object)this.urlService);
        }
        catch (Exception e) {
            try {
                this.urlService = configuration.getProperty(URL_SERVICE_ACCOUNTING_KEY) + PATH_SERVICE_ACCOUNTING + "/";
                logger.debug("urlService from Service End Point:{}", (Object)this.urlService);
            }
            catch (Exception ex) {
                logger.error("Url service not found into configuration from service point");
                throw new IllegalStateException("Url service has a null property", ex);
            }
        }
    }

    protected void reallyAccount(Record record) throws Exception {
        int responseCode;
        logger.trace("init reallyAccount");
        String path = this.urlService + PATH_SERVICE_INSERT_ACCOUNTING;
        URL obj = new URL(path);
        logger.trace("reallyAccount path:{}", (Object)path);
        String recordMarshal = DSMapper.marshal((Record)record);
        if (path.indexOf("http") != -1) {
            logger.trace("accountWithFallback http path:{}", (Object)path);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Content-type", CONTENT_TYPE_JSON);
            con.setRequestProperty("gcube-scope", this.context);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(recordMarshal);
            wr.flush();
            wr.close();
            responseCode = con.getResponseCode();
        } else {
            logger.trace("accountWithFallback https path:{}", (Object)path);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Content-type", CONTENT_TYPE_JSON);
            con.setRequestProperty("gcube-scope", this.context);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(recordMarshal);
            wr.flush();
            wr.close();
            responseCode = con.getResponseCode();
        }
        logger.debug("reallyAccount Post parameters : " + recordMarshal);
        logger.debug("reallyAccount Response Code : " + responseCode);
        switch (responseCode) {
            case 200: {
                logger.trace("accountWithFallback - Send records to service:{}");
                break;
            }
            case 504: {
                throw new TimeoutException("Time out for call service accounting");
            }
            default: {
                throw new Exception("Generic error for service accounting");
            }
        }
    }

    protected void accountWithFallback(Record ... records) throws Exception {
        int responseCode;
        logger.trace("init accountWithFallback");
        String path = this.urlService + PATH_SERVICE_INSERTS_ACCOUNTING;
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Record record : records) {
            logger.trace("add record:{}", (Object)record);
            valuesList.add(DSMapper.marshal((Record)record));
        }
        SerializableList list = new SerializableList(valuesList);
        JAXBContext contextRecord = JAXBContext.newInstance((Class[])new Class[]{SerializableList.class});
        StringWriter writer = new StringWriter();
        contextRecord.createMarshaller().marshal((Object)list, (Writer)writer);
        URL obj = new URL(path);
        if (path.indexOf("http") != -1) {
            logger.trace("accountWithFallback http path:{}", (Object)path);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Content-type", CONTENT_TYPE_XML);
            con.setRequestProperty("gcube-scope", this.context);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(writer.toString());
            wr.flush();
            wr.close();
            responseCode = con.getResponseCode();
        } else {
            logger.trace("accountWithFallback https path:{}", (Object)path);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Content-type", CONTENT_TYPE_XML);
            con.setRequestProperty("gcube-scope", this.context);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(writer.toString());
            wr.flush();
            wr.close();
            responseCode = con.getResponseCode();
        }
        logger.debug("accountWithFallback gcube-scope : " + this.context);
        logger.debug("accountWithFallback Post parameters : " + writer.toString());
        logger.debug("accountWithFallback Response Code : " + responseCode);
        logger.trace("accountWithFallback - Send records to service:{}");
        switch (responseCode) {
            case 200: {
                logger.trace("accountWithFallback - Service respond ok :{}");
                break;
            }
            case 504: {
                throw new TimeoutException("Time out for call service accounting");
            }
            default: {
                throw new Exception("Generic error for service accounting");
            }
        }
    }

    public void close() throws Exception {
    }

    protected void openConnection() throws Exception {
    }

    protected void closeConnection() throws Exception {
    }

    protected void closeAndClean() throws Exception {
    }
}

