/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.clients;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gcube.data.publishing.ckan2zenodo.clients.Zenodo;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.DownloadedFile;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFilesCall
implements Callable<ZenodoDeposition> {
    private static final Logger log = LoggerFactory.getLogger(UploadFilesCall.class);
    private Collection<CkanResource> toUpload;
    private ZenodoDeposition deposition;
    private Zenodo z;

    public UploadFilesCall(Collection<CkanResource> toUpload, ZenodoDeposition deposition, Zenodo z) {
        this.toUpload = toUpload;
        this.deposition = deposition;
        this.z = z;
    }

    @Override
    public ZenodoDeposition call() throws Exception {
        ZenodoDeposition dep = this.deposition;
        log.debug("Starting file transfer for deposition " + this.deposition.getTitle() + " id : " + this.deposition.getId());
        log.debug("Removing not referenced files..");
        HashMap<String, DownloadedFile> resourceMap = new HashMap<String, DownloadedFile>();
        for (CkanResource r : this.toUpload) {
            DownloadedFile downloadedFile = new DownloadedFile(r);
            resourceMap.put(downloadedFile.getToUseFileName(), downloadedFile);
        }
        HashSet<String> alreadyExistingFiles = new HashSet<String>();
        for (FileDeposition fileDeposition : dep.getFiles()) {
            CkanResource found = null;
            if (resourceMap.containsKey(fileDeposition.getFilename())) {
                alreadyExistingFiles.add(fileDeposition.getFilename());
                try {
                    DownloadedFile downloaded = (DownloadedFile)resourceMap.get(fileDeposition.getFilename());
                    if (downloaded.getMD5().equals(fileDeposition.getChecksum())) continue;
                    log.debug("MD5 differ, going to update : " + downloaded + " - " + fileDeposition);
                    this.z.deleteFile(dep, fileDeposition);
                    this.z.uploadFile(dep, found.getName(), downloaded.getFile());
                }
                catch (Throwable t) {
                    log.warn("Unable to update " + fileDeposition, t);
                }
                continue;
            }
            try {
                log.debug("Remote file " + fileDeposition + " is not in requested set. Deleting it..");
                this.z.deleteFile(dep, fileDeposition);
            }
            catch (Throwable t) {
                log.warn("Unable to delete " + fileDeposition, t);
            }
        }
        log.debug("Going to push additional resources for " + this.deposition.getTitle() + " ID : " + this.deposition.getId());
        for (Map.Entry entry : resourceMap.entrySet()) {
            DownloadedFile downloadedFile = (DownloadedFile)entry.getValue();
            if (alreadyExistingFiles.contains(entry.getKey())) continue;
            try {
                this.z.uploadFile(dep, downloadedFile.getToUseFileName(), downloadedFile.getFile());
            }
            catch (Throwable t) {
                log.warn("Unable to upload " + downloadedFile.getSource().getName(), t);
            }
        }
        return this.z.readDeposition(dep.getId());
    }
}

