/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.clients;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.publishing.ckan2zenodo.Fixer;
import org.gcube.data.publishing.ckan2zenodo.LocalConfiguration;
import org.gcube.data.publishing.ckan2zenodo.clients.FileUploaderManager;
import org.gcube.data.publishing.ckan2zenodo.commons.IS;
import org.gcube.data.publishing.ckan2zenodo.model.ZenodoCredentials;
import org.gcube.data.publishing.ckan2zenodo.model.faults.ConfigurationException;
import org.gcube.data.publishing.ckan2zenodo.model.faults.ZenodoException;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.DepositionMetadata;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.FileDeposition;
import org.gcube.data.publishing.ckan2zenodo.model.zenodo.ZenodoDeposition;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zenodo {
    private static final Logger log = LoggerFactory.getLogger(Zenodo.class);
    private static final String CONTENT_TYPE = "application/json";
    private static final String DEPOSITION_BASE_URL = "deposit/depositions";
    private static final String PUBLISH_URL_POST = "actions/publish";
    private static final String NEW_VERSION_URL_POST = "actions/newversion";
    private static final String UNLOCK_URL_POST = "actions/edit";
    private static final String ACCESS_TOKEN = "access_token";
    private static ObjectMapper mapper = new ObjectMapper();
    @NonNull
    private ZenodoCredentials credentials;
    Client client;

    public static final Zenodo get() throws ConfigurationException {
        String eprPlatform;
        String eprCategory = LocalConfiguration.getProperty("ZENODO_ENDPOINT_CATEGORY");
        List<ServiceEndpoint> eps = IS.queryForServiceEndpoints(eprCategory, eprPlatform = LocalConfiguration.getProperty("ZENODO_ENDPOINT_PLATFORM"));
        if (eps.isEmpty()) {
            throw new ConfigurationException("No Zenodo Credentials found (" + eprCategory + " : " + eprPlatform + ")");
        }
        if (eps.size() > 1) {
            throw new ConfigurationException("Multiple [" + eps.size() + "] Zenodo Credentials found (" + eprCategory + " : " + eprPlatform + ")");
        }
        ServiceEndpoint.AccessPoint se = (ServiceEndpoint.AccessPoint)eps.get(0).profile().accessPoints().iterator().next();
        ZenodoCredentials toSet = new ZenodoCredentials(IS.decryptString(se.password()), se.address());
        return new Zenodo(toSet);
    }

    private synchronized Client getWebClient() {
        if (this.client == null) {
            this.client = (Client)ClientBuilder.newClient().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
            this.client.register(MultiPartFeature.class);
        }
        return this.client;
    }

    public ZenodoDeposition readDeposition(Integer id) throws ZenodoException {
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(id + "").queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).get();
        return Zenodo.check(resp, ZenodoDeposition.class);
    }

    private static <T> T check(Response resp, Class<T> clazz) throws ZenodoException {
        if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
            String remoteMessage = (String)resp.readEntity(String.class);
            Integer httpCode = resp.getStatus();
            ZenodoException e = new ZenodoException("RESP STATUS IS " + httpCode + ". Message : " + remoteMessage);
            e.setRemoteMessage(remoteMessage);
            e.setResponseHTTPCode(httpCode);
            throw e;
        }
        if (clazz == null) {
            return null;
        }
        String respString = (String)resp.readEntity(String.class);
        try {
            return (T)mapper.readValue(Fixer.fixIncoming(respString), clazz);
        }
        catch (IOException e) {
            throw new ZenodoException("Unable to parse response from Zenodo. Content was : \n " + respString, e);
        }
    }

    public ZenodoDeposition updateMetadata(ZenodoDeposition dep) throws ZenodoException {
        return this.updateMetadata(dep.getId(), dep.getMetadata());
    }

    public FileDeposition uploadFile(ZenodoDeposition deposition, final String toUploadName, final File toUpload) throws ZenodoException {
        final ZenodoDeposition dep = deposition.getSubmitted() != false ? this.newVersion(deposition.getId()) : deposition;
        log.info("Pushing File {} to Deposition {}", (Object)toUploadName, (Object)dep);
        Callable<Response> call = new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                try {
                    FormDataMultiPart multi = new FormDataMultiPart();
                    FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("file", toUpload, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                    multi.field("name", toUploadName);
                    multi.bodyPart((BodyPart)fileDataBodyPart);
                    log.debug("Starting transfer of " + toUploadName + " into " + dep.getId());
                    Response toReturn = Zenodo.this.getWebClient().target(Zenodo.this.credentials.getBaseUrl()).path(Zenodo.DEPOSITION_BASE_URL).path(dep.getId() + "").path("files").queryParam(Zenodo.ACCESS_TOKEN, new Object[]{Zenodo.this.credentials.getKey()}).request(new String[]{Zenodo.CONTENT_TYPE}).post(Entity.entity((Object)multi, (MediaType)multi.getMediaType()));
                    log.debug("DONE.");
                    return toReturn;
                }
                catch (Throwable e) {
                    throw new ZenodoException("Unable to transfer file " + toUploadName, e);
                }
            }
        };
        log.debug("Submitting request to upload " + toUploadName + " to Manager");
        Future<Response> resp = FileUploaderManager.submitForResponse(call);
        try {
            return Zenodo.check(resp.get(), FileDeposition.class);
        }
        catch (ZenodoException z) {
            throw z;
        }
        catch (Throwable t) {
            throw new ZenodoException(t.getMessage(), t);
        }
    }

    public void deleteFile(ZenodoDeposition dep, FileDeposition toDelete) throws ZenodoException {
        if (dep.getSubmitted().booleanValue()) {
            dep = this.newVersion(dep.getId());
        }
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(dep.getId() + "").path("files").path(toDelete.getId()).queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).delete();
        try {
            Zenodo.check(resp, null);
        }
        catch (ZenodoException z) {
            throw z;
        }
        catch (Throwable t) {
            throw new ZenodoException(t.getMessage(), t);
        }
    }

    public ZenodoDeposition newVersion(Integer originalId) throws ZenodoException {
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(originalId + "").path(NEW_VERSION_URL_POST).queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).post(Entity.json((Object)"{}"));
        ZenodoDeposition d = Zenodo.check(resp, ZenodoDeposition.class);
        resp = this.getWebClient().target(d.getLinks().getLatest_draft()).queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).get();
        try {
            return Zenodo.check(resp, ZenodoDeposition.class);
        }
        catch (ZenodoException z) {
            throw z;
        }
        catch (Throwable t) {
            throw new ZenodoException(t.getMessage(), t);
        }
    }

    private ZenodoDeposition updateMetadata(Integer depositionId, DepositionMetadata meta) throws ZenodoException {
        try {
            String serialized = "{\"metadata\":" + Fixer.fixIncoming(mapper.writeValueAsString((Object)meta)) + "}";
            try {
                Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(depositionId + "").queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).put(Entity.json((Object)serialized));
                return Zenodo.check(resp, ZenodoDeposition.class);
            }
            catch (Throwable t) {
                log.debug("Error while tryin to update " + serialized);
                throw t;
            }
        }
        catch (JsonProcessingException e) {
            log.debug("Error while parsing " + meta, (Throwable)e);
            throw new ZenodoException("Internal error.", e);
        }
    }

    public ZenodoDeposition unlockPublished(Integer depositionId) throws ZenodoException {
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(depositionId + "").path(UNLOCK_URL_POST).queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).post(Entity.json((Object)"{}"));
        return Zenodo.check(resp, ZenodoDeposition.class);
    }

    public void deleteDeposition(Integer depositionId) throws ZenodoException {
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(depositionId + "").queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).delete();
        Zenodo.check(resp, null);
    }

    public ZenodoDeposition createNew() throws ZenodoException {
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).post(Entity.json((Object)"{}"));
        return Zenodo.check(resp, ZenodoDeposition.class);
    }

    public ZenodoDeposition publish(ZenodoDeposition dep) throws ZenodoException {
        return this.publish(dep.getId());
    }

    private ZenodoDeposition publish(Integer depositionId) throws ZenodoException {
        Response resp = this.getWebClient().target(this.credentials.getBaseUrl()).path(DEPOSITION_BASE_URL).path(depositionId + "").path(PUBLISH_URL_POST).queryParam(ACCESS_TOKEN, new Object[]{this.credentials.getKey()}).request(new String[]{CONTENT_TYPE}).post(Entity.json((Object)"{}"));
        return Zenodo.check(resp, ZenodoDeposition.class);
    }

    public Zenodo(@NonNull ZenodoCredentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked @NonNull but is null");
        }
        this.credentials = credentials;
    }

    @NonNull
    public ZenodoCredentials getCredentials() {
        return this.credentials;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

