/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.commons;

import java.io.StringReader;
import java.security.Key;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.publishing.ckan2zenodo.model.faults.ConfigurationException;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Mappings;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IS {
    private static final Logger log = LoggerFactory.getLogger(IS.class);

    public static List<GenericResource> queryForGenericResources(String secondaryType) {
        log.debug("Querying for Service Endpoints [secondary type : {} ]", (Object)secondaryType);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq '" + secondaryType + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        return client.submit((Query)query);
    }

    public static List<ServiceEndpoint> queryForServiceEndpoints(String category, String platformName) {
        log.debug("Querying for Service Endpoints [category : {} , platformName : {}]", (Object)category, (Object)platformName);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platformName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    public static Mappings readMappings(GenericResource res) throws ConfigurationException {
        try {
            String body = res.profile().bodyAsString();
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{Mappings.class}).createUnmarshaller();
            return (Mappings)um.unmarshal((Source)new StreamSource(new StringReader(body)));
        }
        catch (Throwable t) {
            log.debug("Error while parsing mapping from resource " + res.id() + " name : " + res.profile().name(), t);
            throw new ConfigurationException("Invaild mapping resource " + res.id() + " name : " + res.profile().name(), t);
        }
    }

    public static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt : " + toDecrypt, e);
        }
    }
}

