/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.commons;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.gcube.data.publishing.ckan2zenodo.model.CkanResource;
import org.gcube.data.publishing.ckan2zenodo.model.DownloadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Net {
    private static final Logger log = LoggerFactory.getLogger(Net.class);

    public static DownloadedFile download(CkanResource toDownload) throws Exception {
        String urlString = toDownload.getUrl();
        log.debug("Downloading " + urlString);
        URL url = new URL(urlString);
        File temp = File.createTempFile("zenodo_", ".tmp");
        MessageDigest md = MessageDigest.getInstance("MD5");
        InputStream is = null;
        int attempt = 0;
        Exception lastException = null;
        while (is == null && attempt < 5) {
            try {
                ++attempt;
                is = url.openStream();
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep(500 * attempt);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (is == null) {
            throw new Exception("Unable to download " + urlString, lastException);
        }
        DigestInputStream dis = new DigestInputStream(is, md);
        long size = Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return new DownloadedFile(toDownload, temp, dis.getMessageDigest().toString());
    }
}

