package org.gcube.data.publishing.ckan2zenodo.model.parsing;

import java.util.Collections;
import java.util.List;

import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

@RequiredArgsConstructor
@ToString
@Getter
public class ResourceFilter {

	public static final ResourceFilter PASS_ALL=new ResourceFilter(Collections.singletonList(
			new Filter(Collections.singletonList("$.resources[?(@.format)]"))));
	
	@RequiredArgsConstructor
	@ToString
	@Getter
	public static class Filter {
		@NonNull
		private List<String> conditions;
	}
	
	@NonNull
	private List<Filter> filters;
	
}
