package org.gcube.data.publishing.ckan2zenodo.model.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@RequiredArgsConstructor
@Getter
@ToString
public class Mapping {
	
	@RequiredArgsConstructor
	@Getter
	@ToString
	public static class Regexp{
		public static enum Type{
			replace,extract
		}
		@NonNull
		private Type type;
		@NonNull
		private String target;
		@Setter
		private String replacement;
	}
	
	@Getter
	@ToString
	public static class Source{
		
		@RequiredArgsConstructor
		@Getter
		@ToString
		public static class Value{
			public static enum Type{
				jsonPath,constant
			}
			@Setter
			private String split;
			@NonNull
			private Type type;
			@NonNull
			private String value;			
		}
		
		private List<Value> values=new ArrayList<>();
	}
	
	@Getter
	@ToString
	@RequiredArgsConstructor
	public static class TargetElement{	
		@Setter
		private Boolean append = false;
		@NonNull
		private String targetElement;
	}
	
	
	@NonNull
	private Source source;
	@NonNull
	private String targetPath;
	@NonNull
	private TargetElement targetElement;
	@NonNull
	private HashMap<String,String> valueMapping;
	@NonNull
	private List<Regexp> regexp; 

}
