/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.commons;

import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.publishing.ckan2zenodo.model.faults.ConfigurationException;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.Mapping;
import org.gcube.data.publishing.ckan2zenodo.model.parsing.ResourceFilter;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IS {
    private static final Logger log = LoggerFactory.getLogger(IS.class);

    public static List<GenericResource> queryForGenericResources(String secondaryType) {
        log.debug("Querying for Service Endpoints [secondary type : {} ]", (Object)secondaryType);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq '" + secondaryType + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        return client.submit((Query)query);
    }

    public static List<ServiceEndpoint> queryForServiceEndpoints(String category, String platformName) {
        log.debug("Querying for Service Endpoints [category : {} , platformName : {}]", (Object)category, (Object)platformName);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platformName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    public static ArrayList<Mapping> readMappings(GenericResource res) throws ConfigurationException {
        ArrayList<Mapping> toReturn = new ArrayList<Mapping>();
        try {
            Element root = res.profile().body();
            NodeList mappings = root.getElementsByTagName("mapping");
            for (int i = 0; i < mappings.getLength(); ++i) {
                Element mapping = (Element)mappings.item(i);
                Element sourceElement = (Element)mapping.getElementsByTagName("source").item(0);
                NodeList valuesNodeList = sourceElement.getElementsByTagName("value");
                Mapping.Source source = new Mapping.Source();
                for (int j = 0; j < valuesNodeList.getLength(); ++j) {
                    Element valueElement = (Element)valuesNodeList.item(j);
                    source.getValues().add(new Mapping.Source.Value(Mapping.Source.Value.Type.valueOf(valueElement.getAttribute("type")), valueElement.getTextContent()));
                }
                String targetPath = mapping.getElementsByTagName("targetPath").item(0).getTextContent();
                String targetElement = mapping.getElementsByTagName("targetElement").item(0).getTextContent();
                HashMap<String, String> values = new HashMap<String, String>();
                NodeList valueMappings = mapping.getElementsByTagName("valueMapping");
                for (int j = 0; j < valueMappings.getLength(); ++j) {
                    Element codelistMapping = (Element)valueMappings.item(j);
                    String sourceValue = codelistMapping.getElementsByTagName("sourceValue").item(0).getTextContent();
                    String targetValue = codelistMapping.getElementsByTagName("targetValue").item(0).getTextContent();
                    values.put(sourceValue, targetValue);
                }
                ArrayList<Mapping.Regexp> regularExpressions = new ArrayList<Mapping.Regexp>();
                NodeList regexpDeclarations = mapping.getElementsByTagName("regexp");
                for (int j = 0; j < regexpDeclarations.getLength(); ++j) {
                    Element regexpElement = (Element)regexpDeclarations.item(j);
                    String regexpTarget = regexpElement.getElementsByTagName("target").item(0).getTextContent();
                    String typeName = regexpElement.getAttribute("type");
                    Mapping.Regexp regexp = new Mapping.Regexp(Mapping.Regexp.Type.valueOf(typeName), regexpTarget);
                    if (regexp.getType().equals((Object)Mapping.Regexp.Type.replace)) {
                        regexp.setReplacement(regexpElement.getElementsByTagName("replacement").item(0).getTextContent());
                    }
                    regularExpressions.add(regexp);
                }
                toReturn.add(new Mapping(source, targetPath, targetElement, values, regularExpressions));
            }
            return toReturn;
        }
        catch (Throwable t) {
            log.debug("Error while parsing mapping from resource " + res.id() + " name : " + res.profile().name(), t);
            throw new ConfigurationException("Invaild mapping resource " + res.id() + " name : " + res.profile().name(), t);
        }
    }

    public static ResourceFilter readResourceFilters(GenericResource res) throws ConfigurationException {
        try {
            ArrayList<ResourceFilter.Filter> filtersList = new ArrayList<ResourceFilter.Filter>();
            Element root = res.profile().body();
            NodeList filters = ((Element)root.getElementsByTagName("resourceFilters").item(0)).getElementsByTagName("filter");
            for (int i = 0; i < filters.getLength(); ++i) {
                Element filter = (Element)filters.item(i);
                ArrayList<String> conditions = new ArrayList<String>();
                NodeList conditionNodes = filter.getElementsByTagName("condition");
                for (int j = 0; j < conditionNodes.getLength(); ++j) {
                    conditions.add(conditionNodes.item(j).getTextContent());
                }
                if (conditions.isEmpty()) continue;
                filtersList.add(new ResourceFilter.Filter(conditions));
            }
            if (filtersList.isEmpty()) {
                throw new Exception("No Filter actually declared.");
            }
            return new ResourceFilter(filtersList);
        }
        catch (Throwable t) {
            log.debug("Error while parsing filters from resource " + res.id() + " name : " + res.profile().name(), t);
            throw new ConfigurationException("Invalid resource filters declared in " + res.id() + " name : " + res.profile().name(), t);
        }
    }

    public static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt : " + toDecrypt, e);
        }
    }
}

