/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.model.parsing;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class Mapping {
    @NonNull
    private Source source;
    @NonNull
    private String targetPath;
    @NonNull
    private String targetElement;
    @NonNull
    private HashMap<String, String> valueMapping;
    @NonNull
    private List<Regexp> regexp;

    @ConstructorProperties(value={"source", "targetPath", "targetElement", "valueMapping", "regexp"})
    public Mapping(@NonNull Source source, @NonNull String targetPath, @NonNull String targetElement, @NonNull HashMap<String, String> valueMapping, @NonNull List<Regexp> regexp) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (targetPath == null) {
            throw new NullPointerException("targetPath");
        }
        if (targetElement == null) {
            throw new NullPointerException("targetElement");
        }
        if (valueMapping == null) {
            throw new NullPointerException("valueMapping");
        }
        if (regexp == null) {
            throw new NullPointerException("regexp");
        }
        this.source = source;
        this.targetPath = targetPath;
        this.targetElement = targetElement;
        this.valueMapping = valueMapping;
        this.regexp = regexp;
    }

    @NonNull
    public Source getSource() {
        return this.source;
    }

    @NonNull
    public String getTargetPath() {
        return this.targetPath;
    }

    @NonNull
    public String getTargetElement() {
        return this.targetElement;
    }

    @NonNull
    public HashMap<String, String> getValueMapping() {
        return this.valueMapping;
    }

    @NonNull
    public List<Regexp> getRegexp() {
        return this.regexp;
    }

    public String toString() {
        return "Mapping(source=" + this.getSource() + ", targetPath=" + this.getTargetPath() + ", targetElement=" + this.getTargetElement() + ", valueMapping=" + this.getValueMapping() + ", regexp=" + this.getRegexp() + ")";
    }

    public static class Regexp {
        @NonNull
        private Type type;
        @NonNull
        private String target;
        private String replacement;

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        @ConstructorProperties(value={"type", "target"})
        public Regexp(@NonNull Type type, @NonNull String target) {
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (target == null) {
                throw new NullPointerException("target");
            }
            this.type = type;
            this.target = target;
        }

        @NonNull
        public Type getType() {
            return this.type;
        }

        @NonNull
        public String getTarget() {
            return this.target;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String toString() {
            return "Mapping.Regexp(type=" + (Object)((Object)this.getType()) + ", target=" + this.getTarget() + ", replacement=" + this.getReplacement() + ")";
        }

        public static enum Type {
            replace,
            extract;

        }
    }

    public static class Source {
        private List<Value> values = new ArrayList<Value>();

        public List<Value> getValues() {
            return this.values;
        }

        public String toString() {
            return "Mapping.Source(values=" + this.getValues() + ")";
        }

        public static class Value {
            @NonNull
            private Type type;
            @NonNull
            private String value;

            @ConstructorProperties(value={"type", "value"})
            public Value(@NonNull Type type, @NonNull String value) {
                if (type == null) {
                    throw new NullPointerException("type");
                }
                if (value == null) {
                    throw new NullPointerException("value");
                }
                this.type = type;
                this.value = value;
            }

            @NonNull
            public Type getType() {
                return this.type;
            }

            @NonNull
            public String getValue() {
                return this.value;
            }

            public String toString() {
                return "Mapping.Source.Value(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
            }

            public static enum Type {
                jsonPath,
                constant;

            }
        }
    }
}

