/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import net.minidev.json.JSONObject;
import org.gcube.data.publishing.ckan2zenodo.commons.Parsing;
import org.gcube.data.publishing.ckan2zenodo.model.CkanRelatedIdentifier;
import org.gcube.data.publishing.ckan2zenodo.model.faults.InvalidItemException;

public class CkanItemDescriptor {
    private static ObjectMapper mapper = Parsing.getMapper();
    private static final String PROFILE = "$.extras[?(@.key=='system:type')].value";
    private static final String TITLE = "$.title";
    private static final String NOTES = "$.notes";
    private static final String IS_OPEN = "$.isopen";
    private static final String LICENSE_ID = "$.license_id";
    private static final String LICENSE_TITLE = "$.license_title";
    private static final String LICENSE_URL = "$.license_url";
    private static final String TAGS = "$.tags..display_name";
    private static final String VRE = "$.organization.title";
    private static final String VERSION = "$.version";
    private static final String METADATA_CREATED = "$.metadata_created";
    private static final String METADATA_MODIFIED = "$.metadata_modified";
    private static final String AUTHOR = "$.author";
    private static final String MAINTAINER = "$.maintainer";
    private static final String ITEM_URL = "$.extras[?(@.key=='Item URL')].value";
    private static final String NAME = "$.name";
    private static final String ZENODO_DOI = "$.extras[?(@.key=='relatedIdentifier:Zenodo.DOI')].value";
    @NonNull
    private String content;
    private final AtomicReference<Object> document = new AtomicReference();

    private DocumentContext document() {
        return JsonPath.parse((String)this.content);
    }

    public String getProfile() {
        List values = (List)this.getDocument().read(PROFILE, new Predicate[0]);
        if (values == null) {
            return null;
        }
        return (String)values.get(0);
    }

    public String getName() {
        return (String)this.getDocument().read(NAME, new Predicate[0]);
    }

    public String getTitle() {
        return (String)this.getDocument().read(TITLE, new Predicate[0]);
    }

    public String getNotes() {
        return (String)this.getDocument().read(NOTES, new Predicate[0]);
    }

    public Boolean isOpen() {
        return (Boolean)this.getDocument().read(IS_OPEN, new Predicate[0]);
    }

    public String getLicenseId() {
        return (String)this.getDocument().read(LICENSE_ID, new Predicate[0]);
    }

    public String getLicenseTitle() {
        return (String)this.getDocument().read(LICENSE_TITLE, new Predicate[0]);
    }

    public String getLicenseURL() {
        return (String)this.getDocument().read(LICENSE_URL, new Predicate[0]);
    }

    public List<String> getTags() {
        return (List)this.getDocument().read(TAGS, new Predicate[0]);
    }

    public String getVRE() {
        return (String)this.getDocument().read(VRE, new Predicate[0]);
    }

    public String getVersion() {
        return (String)this.getDocument().read(VERSION, new Predicate[0]);
    }

    public String getMetadataCreated() {
        return (String)this.getDocument().read(METADATA_CREATED, new Predicate[0]);
    }

    public String getMetadataModified() {
        return (String)this.getDocument().read(METADATA_MODIFIED, new Predicate[0]);
    }

    public String getAuthor() {
        return (String)this.getDocument().read(AUTHOR, new Predicate[0]);
    }

    public String getMaintainer() {
        return (String)this.getDocument().read(MAINTAINER, new Predicate[0]);
    }

    public String getItemUrl() {
        List values = (List)this.getDocument().read(ITEM_URL, new Predicate[0]);
        if (values == null) {
            return null;
        }
        return (String)values.get(0);
    }

    private String readRelatedIdentifierString() throws InvalidItemException {
        List values = (List)this.getDocument().read(ZENODO_DOI, new Predicate[0]);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new InvalidItemException("Multiple Zenodo Doi found on item.");
        }
        return (String)values.get(0);
    }

    public CkanRelatedIdentifier getZenodoDoi() throws InvalidItemException {
        String s;
        block4: {
            s = this.readRelatedIdentifierString();
            if (s != null) break block4;
            return null;
        }
        try {
            return (CkanRelatedIdentifier)mapper.readValue(s, CkanRelatedIdentifier.class);
        }
        catch (InvalidItemException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InvalidItemException("Unable to parse item ", t);
        }
    }

    public CkanItemDescriptor setZenodoDoi(CkanRelatedIdentifier toSet) throws InvalidItemException {
        if (this.readRelatedIdentifierString() != null) {
            throw new InvalidItemException("Item already contains Zenodo DOI");
        }
        try {
            String serialized = mapper.writeValueAsString((Object)toSet);
            JSONObject obj = new JSONObject();
            obj.put((Object)"key", (Object)"relatedIdentifier:Zenodo.DOI");
            obj.put((Object)"value", (Object)serialized);
            this.getDocument().add("$.extras", (Object)obj, new Predicate[0]);
            this.content = this.getDocument().jsonString();
            return this;
        }
        catch (Throwable t) {
            throw new InvalidItemException("Unable to parse item ", t);
        }
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentContext getDocument() {
        Object value = this.document.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.document;
            synchronized (atomicReference) {
                value = this.document.get();
                if (value == null) {
                    DocumentContext actualValue = this.document();
                    value = actualValue == null ? this.document : actualValue;
                    this.document.set(value);
                }
            }
        }
        return (DocumentContext)(value == this.document ? null : value);
    }

    @ConstructorProperties(value={"content"})
    public CkanItemDescriptor(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        this.content = content;
    }

    public CkanItemDescriptor() {
    }

    public String toString() {
        return "CkanItemDescriptor(content=" + this.getContent() + ", document=" + this.getDocument() + ")";
    }
}

