/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.binders;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.gcube.common.data.Record;
import org.gcube.data.oai.tmplugin.RepositoryProvider;
import org.gcube.data.oai.tmplugin.requests.Request;
import org.gcube.data.oai.tmplugin.utils.Constants;
import org.gcube.data.oai.tmplugin.utils.Utils;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OAIDCBinder
implements Serializable {
    private static final long serialVersionUID = -8037198825787888863L;
    private static final Logger log = LoggerFactory.getLogger(OAIDCBinder.class);
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Request request;

    public OAIDCBinder(Request req) {
        this.request = req;
    }

    public OAIDCBinder(RepositoryProvider p) {
    }

    public Tree bind(Record record) throws Exception {
        try {
            Object mEdge;
            String encodeId = Utils.idEncoder(record.getHeader().getIdentifier());
            Tree tree = new Tree(encodeId);
            StringWriter writer = new StringWriter();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            Element eprElement = XMLUtils.toDOM((OMElement)record.getMetadataElement().getFirstElement());
            transformer.transform(new DOMSource(eprElement), new StreamResult(writer));
            String metadata = writer.toString();
            Document metadataDocument = factory.newDocumentBuilder().parse(new InputSource(new StringReader(metadata)));
            try {
                mEdge = this.createBaseInfoEdge(record, tree, metadataDocument);
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            try {
                mEdge = this.createMetadataEdge(metadataDocument, record.getMetadataPrefix(), record.getMetadata().getSchemaLocation());
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            try {
                mEdge = this.createMainContentEdge(record, tree, metadataDocument);
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            try {
                mEdge = this.createAlternativeContentEdge(tree, metadataDocument);
                tree.add((List)mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            return tree;
        }
        catch (Exception e) {
            log.error("could not convert record:" + record.getHeader().getIdentifier(), (Throwable)e);
            throw new Exception("could not convert record", e);
        }
    }

    private List<Edge> createBaseInfoEdge(Record record, Tree tree, Document metadataDocument) throws Exception {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        try {
            Edge titleEdge = Nodes.e((String)"title", (Object)"");
            if (this.request.getTitleXPath() != null) {
                try {
                    XPathFactory xpathFactory = XPathFactory.newInstance();
                    XPath xPath = xpathFactory.newXPath();
                    NodeList nl = (NodeList)xPath.evaluate(this.request.getTitleXPath(), metadataDocument, XPathConstants.NODESET);
                    if (nl.item(0) != null) {
                        String recordName = nl.item(0).getTextContent();
                        titleEdge = Nodes.e((String)"title", (Object)recordName);
                    }
                }
                catch (Exception e) {
                    log.warn("cannot calculate the title of " + tree.id(), (Throwable)e);
                }
            }
            edgeList.add(titleEdge);
            Edge setEdge = Nodes.e((String)"collectionID", (Object)"");
            String collID = "";
            try {
                collID = (String)record.getHeader().getSpecList().get(0);
            }
            catch (Exception e) {
                log.warn("cannot set the collection ID", (Throwable)e);
            }
            try {
                setEdge = Nodes.e((String)"collectionID", (Object)collID);
            }
            catch (Exception e) {
                log.warn("cannot create setEdge", (Throwable)e);
            }
            edgeList.add(setEdge);
            Calendar timestamp = null;
            try {
                timestamp = Constants.getDate(record.getHeader().getDatestamp());
            }
            catch (Exception e1) {
                log.warn("cannot caluculate", (Object)timestamp);
            }
            Edge creationTimeEdge = Nodes.e((String)"creationTime", (Object)timestamp);
            edgeList.add(creationTimeEdge);
            Edge lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)timestamp);
            edgeList.add(lastUpdateTimeEdge);
            Edge provenanceEdge = Nodes.e((String)"provenance", (Object)"");
            try {
                List<Edge> provenanceEdgeList = this.createProvenanceEdge(record);
                provenanceEdge = Nodes.e((String)"provenance", (Node)Nodes.n((Edge[])provenanceEdgeList.toArray(new Edge[0])));
                edgeList.add(provenanceEdge);
            }
            catch (Exception e) {
                log.warn("cannot create  provenance Edge ", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new Exception("could not create BaseInfo Edge ", e);
        }
        return edgeList;
    }

    private List<Edge> createProvenanceEdge(Record record) throws Exception {
        String provenance = "This item has been created by the gCube OAI-TM plugin via OAI-PMH metadata harvesting from the metadata provider " + this.request.getName() + " at " + this.request.getRepositoryUrl();
        ArrayList<Edge> provenanceEdgeList = new ArrayList<Edge>();
        provenanceEdgeList.add(Nodes.e((String)"statement", (Object)provenance));
        List sets = record.getHeader().getSpecList();
        for (int i = 0; i < sets.size(); ++i) {
            provenanceEdgeList.add(Nodes.e((String)"setID", sets.get(i)));
        }
        provenanceEdgeList.add(Nodes.e((String)"recordID", (Object)record.getHeader().getIdentifier()));
        return provenanceEdgeList;
    }

    private Edge createMetadataEdge(Document metadataDocument, String schema, String schemaLocation) throws Exception {
        Edge metadataEdge = this.createTreeByMetadata(metadataDocument);
        if (schema == null) {
            schema = "";
        }
        if (schemaLocation == null) {
            schemaLocation = "";
        }
        return Nodes.e((String)"metadata", (Node)new InnerNode(new Edge[]{Nodes.e((String)"schema", (Object)schema), Nodes.e((String)"schemaLocation", (Object)schemaLocation), metadataEdge}));
    }

    private Edge createTreeByMetadata(Document doc) {
        Edge metadataEdge = Nodes.e((String)"record", (Object)"");
        try {
            Edge edge = this.printNodeInfo(doc.getDocumentElement(), null);
            metadataEdge = Nodes.e((String)"record", (Node)new InnerNode(new Edge[]{edge}));
        }
        catch (Exception e) {
            log.error("error creating TreeByMetadata", (Throwable)e);
        }
        return metadataEdge;
    }

    public Edge printNodeInfo(org.w3c.dom.Node currentNode, Edge edge) {
        NamedNodeMap nnmAttributes;
        short sNodeType = currentNode.getNodeType();
        String sNodeName = null;
        ArrayList<Edge> children = new ArrayList<Edge>();
        if (sNodeType == 1) {
            sNodeName = currentNode.getNodeName();
            String sNodeValue = OAIDCBinder.searchTextInElement(currentNode);
            if (sNodeValue != null) {
                if (!sNodeValue.trim().equalsIgnoreCase("")) {
                    edge = Nodes.e((String)sNodeName, (Object)sNodeValue);
                } else if (!currentNode.hasChildNodes()) {
                    edge = Nodes.e((String)sNodeName, (Object)"");
                }
            }
            int iChildNumber = currentNode.getChildNodes().getLength();
            if (currentNode.hasChildNodes()) {
                NodeList nlChilds = currentNode.getChildNodes();
                for (int iChild = 0; iChild < iChildNumber; ++iChild) {
                    if (nlChilds.item(iChild).getNodeType() != 1) continue;
                    children.add(this.printNodeInfo(nlChilds.item(iChild), null));
                }
            }
        }
        if (children.size() > 0) {
            InnerNode innerNode = new InnerNode(children.toArray(new Edge[0]));
            edge = Nodes.e((String)sNodeName, (Node)innerNode);
        }
        if ((nnmAttributes = currentNode.getAttributes()).getLength() > 0) {
            OAIDCBinder.setAttributes(nnmAttributes, edge.target());
        }
        return edge;
    }

    private static String searchTextInElement(org.w3c.dom.Node elementNode) {
        String sText = "";
        if (elementNode.hasChildNodes()) {
            org.w3c.dom.Node nTextChild = elementNode.getChildNodes().item(0);
            sText = nTextChild.getNodeValue();
        }
        return sText;
    }

    private static boolean setAttributes(NamedNodeMap nnm, Node node) {
        if (nnm != null && nnm.getLength() > 0) {
            for (int iAttr = 0; iAttr < nnm.getLength(); ++iAttr) {
                String name = nnm.item(iAttr).getNodeName();
                String value = nnm.item(iAttr).getNodeValue();
                if (name.contains("xsi")) continue;
                node.setAttribute(name, value);
            }
            return true;
        }
        return false;
    }

    private Edge createMainContentEdge(Record record, Tree tree, Document metadataDocument) throws Exception {
        Edge urlEdge;
        Edge mimeTypeEdge;
        Edge contentTypeEdge;
        block6: {
            contentTypeEdge = Nodes.e((String)"contentType", (Object)"");
            mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"");
            urlEdge = Nodes.e((String)"url", (Object)"");
            try {
                if (this.request.getContentXPath() == null) break block6;
                try {
                    contentTypeEdge = Nodes.e((String)"contentType", (Object)"main");
                    XPathFactory factory = XPathFactory.newInstance();
                    XPath xPath = factory.newXPath();
                    NodeList nl = (NodeList)xPath.evaluate(this.request.getContentXPath(), metadataDocument, XPathConstants.NODESET);
                    if (nl.item(0) == null) break block6;
                    String contentUri = nl.item(0).getTextContent();
                    String url = Utils.resolver(contentUri);
                    try {
                        mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"text/url");
                    }
                    catch (Exception e) {
                        log.warn("could not retrieve mime type for " + record.getHeader().getIdentifier());
                    }
                    urlEdge = Nodes.e((String)"url", (Object)url);
                }
                catch (Throwable e) {
                    log.error("could not retrieve content for " + tree.id(), e);
                }
            }
            catch (Exception e) {
                throw new Exception("could not create MainContent Edge ", e);
            }
        }
        return Nodes.e((String)"content", (Node)new InnerNode(new Edge[]{contentTypeEdge, mimeTypeEdge, urlEdge}));
    }

    private List<Edge> createAlternativeContentEdge(Tree tree, Document metadataDocument) throws Exception {
        List<Edge> edgeList = new ArrayList<Edge>();
        try {
            for (int i = 0; i < this.request.getAlternativesXPath().size(); ++i) {
                String path = this.request.getAlternativesXPath().get(i);
                try {
                    edgeList = this.createAlternatives(i, path, metadataDocument);
                    continue;
                }
                catch (Exception te) {
                    log.warn("could not retrieve alternatives in " + tree.id() + " with path " + path, (Throwable)te);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("could not create AlternativeContent Edge ", e);
        }
        return edgeList;
    }

    private List<Edge> createAlternatives(int identifier, String path, Document metadataDocument) throws Exception {
        ArrayList<Edge> edgeList = null;
        try {
            edgeList = new ArrayList<Edge>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            NodeList nl = (NodeList)xPath.evaluate(path, metadataDocument, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Edge contentTypeEdge = Nodes.e((String)"contentType", (Object)"alternative");
                String alternativeUri = "";
                try {
                    alternativeUri = nl.item(i).getTextContent();
                    Edge mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"none");
                    URI uri = new URI(alternativeUri);
                    URLConnection urlConnection = null;
                    urlConnection = uri.toURL().openConnection();
                    mimeTypeEdge = Nodes.e((String)"mimeType", (Object)urlConnection.getContentType());
                    edgeList.add(Nodes.e((String)"content", (Node)Nodes.n((Edge[])new Edge[]{contentTypeEdge, mimeTypeEdge, Nodes.e((String)"url", (Object)alternativeUri)})));
                    continue;
                }
                catch (Exception e) {
                    log.warn("impossible to retrieve alternative, maybe the URI has an illegal characters: " + alternativeUri);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("could not create Alternatives ", e);
        }
        return edgeList;
    }
}

