/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin;

import java.util.Timer;
import java.util.TimerTask;
import org.gcube.data.oai.tmplugin.OAISource;
import org.gcube.data.oai.tmplugin.repository.Summary;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.gcube.data.tmf.impl.LifecycleAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Lifecycle
extends LifecycleAdapter {
    private static final long serialVersionUID = -7621722603411835052L;
    private static final long startDelay = 60000L;
    private static final long periodRepeating = 604800000L;
    private static Logger log = LoggerFactory.getLogger(Lifecycle.class);
    private OAISource source;

    public Lifecycle(OAISource source) {
        log.info("source " + (Object)((Object)source));
        this.source = source;
    }

    public void reconfigure(Element request) throws InvalidRequestException, Exception {
        super.reconfigure(request);
    }

    public void init() throws Exception {
        log.info("initialising source {}", (Object)this.source.id());
        Timer timer = new Timer();
        timer.schedule((TimerTask)new UpdateTask(), 60000L, 604800000L);
    }

    public void resume() {
        log.info("resuming collection {}", (Object)this.source.id());
        Timer timer = new Timer();
        timer.schedule((TimerTask)new UpdateTask(), 60000L, 604800000L);
    }

    private class UpdateTask
    extends TimerTask {
        private UpdateTask() {
        }

        @Override
        public void run() {
            log.info("computing summary for source " + Lifecycle.this.source.id());
            try {
                log.info("source.reader() " + (Object)((Object)Lifecycle.this.source.reader()));
                Summary pair = Lifecycle.this.source.reader().summary();
                log.trace("cardinality is {} and lastUpdate is {}", (Object)pair.cardinality(), (Object)pair.lastUpdate().getTime());
                Lifecycle.this.source.setCardinality(pair.cardinality());
                Lifecycle.this.source.setLastUpdate(pair.lastUpdate());
            }
            catch (Exception e) {
                log.warn("error computing collection summary for collection {}", (Object)Lifecycle.this.source.id(), (Object)e);
            }
            log.info("computed summary for collection " + Lifecycle.this.source.id());
        }
    }
}

