/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.requests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Request
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String url;
    @XmlElement
    private List<String> alternativesXPath = new ArrayList<String>();
    @XmlElement
    private String contentXPath;
    @XmlElement
    private String titleXPath;
    @XmlElement
    private String metadataFormat;
    @XmlElement
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private List<String> sets = new ArrayList<String>();

    Request() {
    }

    Request(String url) throws IllegalArgumentException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("repository url is null or empty");
        }
        this.url = url;
    }

    public String getRepositoryUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getAlternativesXPath() {
        return this.alternativesXPath;
    }

    public String getContentXPath() {
        return this.contentXPath;
    }

    public String getTitleXPath() {
        return this.titleXPath;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public List<String> getSets() {
        return this.sets;
    }

    public void addSets(String ... setIds) {
        if (setIds != null) {
            this.sets.addAll(Arrays.asList(setIds));
        }
    }

    public void setContentXPath(String path) {
        this.contentXPath = path;
    }

    public void setRepositoryUrl(String path) {
        this.url = path;
    }

    public void setTitleXPath(String path) {
        this.titleXPath = path;
    }

    public void addAlternativesXPath(String ... path) {
        if (path != null) {
            this.alternativesXPath.addAll(Arrays.asList(path));
        }
    }

    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sets == null ? 0 : ((Object)this.sets).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.alternativesXPath == null ? 0 : ((Object)this.alternativesXPath).hashCode());
        result = 31 * result + (this.contentXPath == null ? 0 : this.contentXPath.hashCode());
        result = 31 * result + (this.titleXPath == null ? 0 : this.titleXPath.hashCode());
        result = 31 * result + (this.metadataFormat == null ? 0 : this.metadataFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.alternativesXPath == null ? other.alternativesXPath != null : !((Object)this.alternativesXPath).equals(other.alternativesXPath)) {
            return false;
        }
        if (this.contentXPath == null ? other.contentXPath != null : !this.contentXPath.equals(other.contentXPath)) {
            return false;
        }
        if (this.titleXPath == null ? other.titleXPath != null : !this.titleXPath.equals(other.titleXPath)) {
            return false;
        }
        if (this.metadataFormat == null ? other.metadataFormat != null : !this.metadataFormat.equals(other.metadataFormat)) {
            return false;
        }
        return !(this.sets == null ? other.sets != null : !((Object)this.sets).equals(other.sets));
    }
}

