package org.gcube.data.oai.tmplugin.requests;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.oai.tmplugin.Constants;

/**
 * A {@link Request} to bind the OAI Plugin to a single data source formed of all the records in one ore more sets of an OAI repository.
 *  
 * @author Fabio Simeoni
 *
 */
@XmlRootElement(namespace = Constants.NS)
@XmlAccessorType(XmlAccessType.FIELD)
public class WrapRepositoryRequest extends Request implements Serializable{

	@XmlElement
	private String id;

	private static final long serialVersionUID = 1L;


	public WrapRepositoryRequest() {
	}

	/**
	 * Creates an instance with a given source identifier and the URL of a given OAI repository.
	 * @param id the source identifier
	 * @param url the URL
	 * @throws IllegalArgumentException if the identifier is null or empty
	 */
	public WrapRepositoryRequest(String id, String url) throws IllegalArgumentException {

		super(url);

		if (id == null || id.isEmpty())
			throw new IllegalArgumentException("repository identifier is null or empty");

		this.setId(id);
	}


	/**
	 * Returns the identifier of the source to bind.
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Returns the identifier of the source to bind.
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		WrapRepositoryRequest other = (WrapRepositoryRequest) obj;
		
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("WrapRepositoryRequest [id=");
		builder.append(this.getId());
		builder.append(", name=");
		builder.append(super.getName());
		builder.append(", description=");
		builder.append(super.getDescription());
		builder.append(", url=");
		builder.append(super.getRepositoryUrl());
		builder.append(", alternativesXPath=");
		builder.append(super.getAlternativesXPath());
		builder.append(", contentXPath=");
		builder.append(super.getContentXPath());
		builder.append(", titleXPath=");
		builder.append(super.getTitleXPath());
		builder.append("]");
		return builder.toString();
	}


}
