/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

public abstract class Request {
    @XmlElement
    private String url;
    @XmlElement
    private List<String> alternativesXPath = new ArrayList<String>();
    @XmlElement
    private String contentXPath;
    @XmlElement
    private String titleXPath;
    @XmlElement
    private List<String> sets = new ArrayList<String>();

    Request() {
    }

    Request(String url) throws IllegalArgumentException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("repository url is null or empty");
        }
        this.url = url;
    }

    public String getRepositoryUrl() {
        return this.url;
    }

    public List<String> getAlternativesXPath() {
        return this.alternativesXPath;
    }

    public String contentXPath() {
        return this.contentXPath;
    }

    public String titleXPath() {
        return this.titleXPath;
    }

    public List<String> getSets() {
        return this.sets;
    }

    public void setContentXPath(String path) {
        this.contentXPath = path;
    }

    public void setTitleXPath(String path) {
        this.titleXPath = path;
    }

    public void addAlternativesXPath(String ... path) {
        if (path != null) {
            this.alternativesXPath.addAll(Arrays.asList(path));
        }
    }

    public void addSets(String ... setIds) {
        if (setIds != null) {
            this.sets.addAll(Arrays.asList(setIds));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.alternativesXPath == null ? 0 : this.alternativesXPath.hashCode());
        result = 31 * result + (this.contentXPath == null ? 0 : this.contentXPath.hashCode());
        result = 31 * result + (this.titleXPath == null ? 0 : this.titleXPath.hashCode());
        result = 31 * result + (this.sets == null ? 0 : this.sets.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.alternativesXPath == null ? other.alternativesXPath != null : !this.alternativesXPath.equals(other.alternativesXPath)) {
            return false;
        }
        if (this.contentXPath == null ? other.contentXPath != null : !this.contentXPath.equals(other.contentXPath)) {
            return false;
        }
        if (this.titleXPath == null ? other.titleXPath != null : !this.titleXPath.equals(other.titleXPath)) {
            return false;
        }
        return !(this.sets == null ? other.sets != null : !this.sets.equals(other.sets));
    }
}

