package org.gcube.data.oai.tmplugin.requests;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.oai.tmplugin.Constants;

/**
 * A {@link Request} to bind the OAI Plugin to one or more sets of an OAI
 * repository.
 * 
 * @author Fabio Simeoni
 * 
 */
@XmlRootElement(namespace = Constants.NS)
public class WrapSetsRequest extends Request {

	@XmlElement
	private String prefix;

	protected WrapSetsRequest() {
	}

	/**
	 * Creates an instance with the URL of an OAI repository and a prefix for
	 * the names of the sets to use as the names of the corresponding sources.
	 * 
	 * @param prefix
	 *            the prefix
	 * @param url
	 *            the URL
	 * @throws IllegalArgumentException
	 *             if the prefix is null or empty
	 */
	public WrapSetsRequest(String prefix, String url)
			throws IllegalArgumentException {

		super(url);

		if (prefix == null || prefix.isEmpty())
			throw new IllegalArgumentException(
					"source identifier prefix is null or empty");

		this.prefix = prefix;
	}

	/**
	 * Returns the prefix for the name of the sources to bind.
	 * @return the prefix
	 */
	public String idPrefix() {
		return prefix;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((prefix == null) ? 0 : prefix.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		WrapSetsRequest other = (WrapSetsRequest) obj;
		if (prefix == null) {
			if (other.prefix != null)
				return false;
		} else if (!prefix.equals(other.prefix))
			return false;
		return true;
	}


}
