package org.gcube.data.oai.tmplugin.binders;

import static org.apache.axis.encoding.Base64.*;
import static org.gcube.data.gml.constants.Labels.*;
import static org.gcube.data.trees.data.Nodes.*;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Calendar;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.gcube.data.oai.tmplugin.Constants;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import uiuc.oai.OAIRecord;

public class OAIDCBinder implements Serializable {

	private static final long serialVersionUID = -8037198825787888863L;

	private final static Logger log = LoggerFactory.getLogger(OAIDCBinder.class);
	
	private final static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	private final static TransformerFactory transformerFactory = TransformerFactory.newInstance();
	
	private final static String oaidc_schema="http://www.openarchives.org/OAI/2.0/oai_dc/";
	private final static String oaidc_prefix="oai_dc";
	

	public Tree bind(OAIRecord record) throws Exception {
		try {
			
			Tree tree=new Tree(record.getIdentifier());
			
			Calendar timestamp = Constants.getDate(record.getDatestamp());
			Edge creationTimeEdge = e(CREATION_TIME,timestamp);
			Edge lastUpdateTimeEdge = e(LAST_UPDATE,timestamp);
			
			tree.add(creationTimeEdge,lastUpdateTimeEdge);
			
			StringWriter writer= new StringWriter();
			
			Transformer transformer= transformerFactory.newTransformer();
			transformer.setOutputProperty( OutputKeys.ENCODING, "utf-8");
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			transformer.transform(new DOMSource(record.getMetadata()), new StreamResult(writer));
	
			//logger.trace("time spent to retrieve metadata "+(System.currentTimeMillis()-startmetadata)); 			
			
			//Adding default metadata
			String metadata = writer.toString();
			try { 
				Edge mEdge = createMetadataEdge(metadata,oaidc_prefix,oaidc_schema,tree.id(), creationTimeEdge, lastUpdateTimeEdge);
			     tree.add(mEdge); 
			} catch (Exception te) {
				log.warn("error retrieving the metadata",te);
			}
			
			//BaseRequest config = repository.request();
			
			//retrieve extra record metadata here
			Document metadataDocument = factory.newDocumentBuilder().parse(
										new InputSource(new StringReader(writer.toString())));
			//can we do it in a method? sure //TODO
			//calculating the content
			Edge mimeTypeEdge=e(MIME_TYPE,"");
			Edge lengthEdge=e(LENGTH,0);
			Edge contentEdge=e(BYTESTREAM_URI,"");
			Edge nameEdge=e(NAME,record.getIdentifier());
//			if (config.contentPath()!=null){
//				try{
//					XPath xPath= xpathFactory.newXPath();
//					NodeList nl=(NodeList) xPath.evaluate(config.contentPath(),metadataDocument,XPathConstants.NODESET);
//					
//					//logger.trace("time spent to retrieve content "+(System.currentTimeMillis()-startcontent)); 
//					
//					if (nl.item(0)!=null){
//						String contentUri= nl.item(0).getTextContent();
//						try{
//							mimeTypeEdge=e(MIME_TYPE,"text/url");
//						}catch(Exception e){
//							log.warn("could not retrieve mime type for "+tree.id());
//						}
//	
//						try{
//							lengthEdge=e(LENGTH,contentUri.getBytes("utf-8").length);
//						}catch(Exception e){
//							log.warn("could not retrieve content length for "+tree.id());}
//						
//						contentEdge= e(BYTESTREAM_URI,contentUri);
//						//logger.trace("time spent to add content as edge "+(System.currentTimeMillis()-startrest));
//					}
//				}catch(Throwable e){
//					log.error("could not retrieve content for "+record.getIdentifier(),e);
//				}
//			}
			
//			//retrieving the record title
//			if (config.titlePath()!=null){
//				try{	
//					XPath xPath= xpathFactory.newXPath();
//					NodeList nl=(NodeList) xPath.evaluate(config.titlePath(),metadataDocument,XPathConstants.NODESET);
//					if (nl.item(0)!=null){
//						String recordName= nl.item(0).getTextContent();
//						nameEdge=e(NAME,recordName);
//					}
//				}catch(Exception e){
//					log.warn("cannot calculate the title of "+tree.id(),e);
//				}
//			}
			
			tree.add(mimeTypeEdge, lengthEdge, contentEdge, nameEdge);
			//logger.trace("time spent to retrieve title "+(System.currentTimeMillis()-starttitle));
			
			//adding alternatives
			//logger.trace("trying to extract alternativesXpath "+this.alternativesXPath);
//			for (int i=0; i<config.alternativesPath().size(); i++) {
//					String path = config.alternativesPath().get(i);
//					try{
//						tree.add(createAlternatives(metadataDocument, i, path, creationTimeEdge, lastUpdateTimeEdge));
//					} catch (Exception te) {
//						log.warn("could not retrieve alternatives in "+tree.id()+" with path "+path,te);}
//			}
			
			return tree;
		}
		catch(Exception e) {
			log.error("could not convert record:"+record,e);
			throw new Exception("could not convert record",e);
		}
	}

	//helper
	private Edge createMetadataEdge(String metadata, String prefix, String schema, String identifier, Edge createTimeEdge, Edge lastUpdateTimeEdge) throws Exception{
		return e(METADATA,new InnerNode(identifier+"-"+prefix,e(MIME_TYPE,"text/xml"),e(LENGTH,metadata.length()),
				e(LANGUAGE,"unknown"),e(SCHEMA_NAME,prefix),e(SCHEMA_URI,schema),
				e(BYTESTREAM,encode(metadata.getBytes("utf-8"))), createTimeEdge, lastUpdateTimeEdge));
	}
	
}
