/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.repository.iterators;

import org.gcube.data.oai.tmplugin.repository.iterators.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uiuc.oai.OAIException;
import uiuc.oai.OAIRecordList;

public abstract class RepositoryIterator
extends RecordIterator {
    private static final Logger log = LoggerFactory.getLogger(RepositoryIterator.class);

    public boolean hasNext() {
        try {
            if (this.records == null) {
                this.records = this.fetchRecords();
                log.trace("expecting to iterate over a max of {}", (Object)this.records.getCompleteSize());
                return this.hasNext();
            }
            return this.records.moreItems();
        }
        catch (OAIException moveToNextSet) {
            log.error("could not list records from {}", (Throwable)moveToNextSet);
            return false;
        }
    }

    protected abstract OAIRecordList fetchRecords() throws OAIException;
}

