package org.gcube.data.harmonization.occurrence;

import java.util.List;
import java.util.Map;

import org.gcube.data.harmonization.occurrence.model.ImportedOccurrenceSet;
import org.gcube.data.harmonization.occurrence.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.model.SubmittedOperation;
import org.gcube.data.harmonization.occurrence.model.statistical.StatisticalOperation;

public interface Reconciliation {

	/**
	 * Imports selected file from user's workspace
	 * 
	 * @param fileId 
	 * @return imported Id
	 */
	public String importOccurrenceFromWorkspace(String fileId) throws Exception;
	
	
	/**
	 * 
	 * 
	 * @return
	 */
	public List<ImportedOccurrenceSet> getImportedList()throws Exception;
	
	
	/**
	 * Get Json view of currently connected table
	 * 
	 * @param importedId
	 * @param settings
	 * @return
	 */
	public String getJSONImported(PagedRequestSettings settings)throws Exception;
	
	
	/**
	 * Opens connection to a table for direct inspection
	 * 
	 * @param tableId
	 * @return list of field of selected table
	 * @throws Exception
	 */
	public List<String> openTableInspection(String tableId)throws Exception;
	
	
	public void closeTableConnection()throws Exception;
	
	
	
	/**
	 * Gets information about available operation on occurrence point data sets
	 * 
	 * @return list of Statistical Operation, one for each available algorithm
	 * 
	 */
	public List<StatisticalOperation> getCapabilities()throws Exception;
	
	
	
	/**
	 * Get result of the selected operation
	 * 
	 * @param operationId
	 */
	public void getResult(String operationId)throws Exception;
	
	
	/**
	 * Save selected result to workspace 
	 * 
	 * @param operationId
	 * @return saved Item id
	 */
	public String saveResultToWorkspace(String operationId)throws Exception;
	
	
	
	/**
	 * Submit operation process on selected imported data set 
	 * 
	 * @param importedId
	 * @param operation
	 * @param parameters
	 * @return
	 */
	public String submitUnaryOperation(String importedId,String operation,Map<String,String> parameters)throws Exception;
	
	
	public List<SubmittedOperation> getSubmittedOperationList()throws Exception;
}
