/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.services;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.db.model.ImportReference;
import org.gcube.data.harmonization.occurrence.db.model.MergeReference;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;
import org.gcube.data.harmonization.occurrence.stubs.ImportRequestType;
import org.gcube.data.harmonization.occurrence.stubs.InvalidRequestFault;
import org.gcube.data.harmonization.occurrence.stubs.MergeImportedRequestType;
import org.gcube.data.harmonization.occurrence.stubs.ReconciliationPortType;

public class Reconciliation
extends GCUBEPortType
implements ReconciliationPortType {
    private static GCUBELog logger = new GCUBELog(Reconciliation.class);

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public VOID importDataSet(ImportRequestType request) throws RemoteException, GCUBEFault, InvalidRequestFault {
        try {
            GCUBEScope callerScope = ServiceContext.getContext().getScope();
            logger.trace((Object)("Received Import request [Author=" + request.getAuthor() + ",TYPE=" + request.getRequestType() + ",URI=" + request.getSourceLocation() + ",SCOPE=" + callerScope + "]"));
            ImportReference.ImportRequest req = new ImportReference.ImportRequest(callerScope, request.getAuthor(), request.getSourceLocation(), request.getRequestType());
            ServiceContext.getContext().getImportModule().insertRequest(req);
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to insert request, ", (Throwable)e);
            throw new GCUBEFault(new String[]{e.getMessage()});
        }
    }

    public VOID mergeImported(MergeImportedRequestType request) throws RemoteException, GCUBEFault, InvalidRequestFault {
        try {
            GCUBEScope callerScope = ServiceContext.getContext().getScope();
            logger.trace((Object)"Received Merge request ");
            if (request.getToMergeIds() == null || request.getToMergeIds().getItems() == null || request.getToMergeIds().getItems().length == 0) {
                throw new InvalidRequestFault();
            }
            MergeReference.MergeRequest req = new MergeReference.MergeRequest(callerScope, request.getAuthor(), new ArrayList<String>(Arrays.asList(request.getToMergeIds().getItems())));
            ServiceContext.getContext().getMergeModule().insertRequest(req);
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to insert request, ", (Throwable)e);
            throw new GCUBEFault(new String[]{e.getMessage()});
        }
    }
}

