/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.operating;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference;
import org.gcube.data.harmonization.occurrence.operating.OperatingModuleConfiguration;
import org.gcube.data.harmonization.occurrence.queue.QueueReceiver;
import org.gcube.data.harmonization.occurrence.queue.QueueSender;

public class OperatingModule<U extends ExecutionReference, T extends QueueReceiver> {
    private static GCUBELog logger = new GCUBELog(OperatingModule.class);
    private Connection connection;
    private OperatingModuleConfiguration<U, T> configuration;

    public void init(OperatingModuleConfiguration<U, T> configuration) throws Exception {
        logger.debug((Object)("Initializing Operating Module (" + configuration.getHanlderClass().getName() + "), passed configuration " + configuration));
        this.configuration = configuration;
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(this.configuration.getQueueConnectionHost());
        this.connection = connectionFactory.newConnection();
        int i = 0;
        while (i < this.configuration.getMaxWorkerThreads()) {
            QueueReceiver toLaunch = (QueueReceiver)this.configuration.getHanlderClass().newInstance();
            toLaunch.bind(this.connection.createChannel(), this.configuration.getMessageRoutingKey());
            toLaunch.start();
            ++i;
        }
        logger.debug((Object)"Initialization complete");
    }

    public void insertRequest(ExecutionReference.ExecutionRequest request) throws Exception {
        QueueSender sender = new QueueSender(this.connection.createChannel(), this.configuration.getMessageRoutingKey());
        sender.sendMessage(request);
    }
}

