/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.db.model;

import com.j256.ormlite.dao.CloseableWrappedIterable;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionState;
import org.gcube.data.harmonization.occurrence.db.model.MergeReference;
import org.gcube.data.harmonization.occurrence.db.model.ToMergeImported;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;
import org.gcube.data.harmonization.occurrence.stubs.ImportType;
import org.gcube.data.harmonization.occurrence.stubs.utils.RSWrapper;

@DatabaseTable
public class ImportReference
extends ExecutionReference {
    public static final String STREAM_FIELD = "stream";
    public static final String PERSISTENCE_FIELD = "persistence";
    public static final String TO_MERGE_FIELD = "merge_id";
    public static final String IMPORT_TYPE_FILED = "type";
    @DatabaseField(canBeNull=false, dataType=DataType.STRING_BYTES, columnName="stream")
    private String streamUri;
    @DatabaseField(dataType=DataType.STRING_BYTES, columnName="persistence")
    private String persistenceUri;
    @ForeignCollectionField(eager=false, columnName="merge_id")
    private ForeignCollection<ToMergeImported> toMergeImportedReferences;
    @DatabaseField(canBeNull=false, columnName="type", dataType=DataType.SERIALIZABLE)
    private ImportType type;

    public ImportReference(ImportRequest request) throws Exception {
        super(request);
        this.setState(ExecutionState.READY);
        this.setType(request.getType());
        if (this.getType().equals((Object)ImportType.MANUAL_UPLOAD)) {
            FileOutputStream fos = null;
            try {
                try {
                    File localFile = File.createTempFile("manual", "");
                    fos = new FileOutputStream(localFile);
                    IOUtils.copy((InputStream)new FileInputStream(RSWrapper.getStreamFromLocator((URI)new URI(request.getToReadStream()))), (OutputStream)fos);
                    this.setStreamUri(localFile.getAbsolutePath());
                }
                catch (Exception e) {
                    logger.error((Object)("Unexpected error while copying data from RS, uri was " + request.getToReadStream()), (Throwable)e);
                    throw new Exception("Unable to copy data");
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    IOUtils.closeQuietly(fos);
                }
                throw throwable;
            }
            if (fos != null) {
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
        logger.debug((Object)("Going to insert " + this));
        ServiceContext.getContext().getImportDao().create((Object)this);
    }

    public ImportReference() {
    }

    public ForeignCollection<ToMergeImported> getToMergeImportedReferences() {
        return this.toMergeImportedReferences;
    }

    public void setToMergeImportedReferences(ForeignCollection<ToMergeImported> toMergeImportedReferences) {
        this.toMergeImportedReferences = toMergeImportedReferences;
    }

    public ImportType getType() {
        return this.type;
    }

    public void setType(ImportType type) {
        this.type = type;
    }

    public String getStreamUri() {
        return this.streamUri;
    }

    public void setStreamUri(String streamUri) {
        this.streamUri = streamUri;
    }

    public String getPersistenceUri() {
        return this.persistenceUri;
    }

    public void setPersistenceUri(String persistenceUri) {
        this.persistenceUri = persistenceUri;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImportReference [streamUri=");
        builder.append(this.streamUri);
        builder.append(", persistenceUri=");
        builder.append(this.persistenceUri);
        builder.append(", getId()=");
        builder.append(this.getId());
        builder.append(", getSubmissionTime()=");
        builder.append(this.getSubmissionTime());
        builder.append(", getStartTime()=");
        builder.append(this.getStartTime());
        builder.append(", getCompletionTime()=");
        builder.append(this.getCompletionTime());
        builder.append(", getAuthor()=");
        builder.append(this.getAuthor());
        builder.append(", getState()=");
        builder.append((Object)this.getState());
        builder.append(", getScope()=");
        builder.append(this.getScope());
        builder.append(", getProgress()=");
        builder.append(this.getProgress());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void updateStatus(ExecutionState toSet) throws Exception {
        this.setState(toSet);
        if (toSet.equals((Object)ExecutionState.STARTED)) {
            this.setStartTime(System.currentTimeMillis());
        } else if (toSet.equals((Object)ExecutionState.COMPLETED) || toSet.equals((Object)ExecutionState.ERROR)) {
            this.setCompletionTime(System.currentTimeMillis());
        }
        ServiceContext.getContext().getImportDao().update((Object)this);
        if (toSet.equals((Object)ExecutionState.COMPLETED) || toSet.equals((Object)ExecutionState.ERROR)) {
            logger.debug((Object)("Status setted was " + (Object)((Object)toSet) + ", notifying related mergeReference"));
            ExecutionState mergeState = toSet.equals((Object)ExecutionState.COMPLETED) ? ExecutionState.READY : ExecutionState.ERROR;
            PreparedQuery<MergeReference> mergeQuery = null;
            CloseableWrappedIterable mergeIterator = null;
            try {
                mergeQuery = ToMergeImported.getMergePerImportPreparedQuery();
                mergeQuery.setArgumentHolderValue(0, (Object)this);
                mergeIterator = ServiceContext.getContext().getMergeDao().getWrappedIterable(mergeQuery);
                PreparedQuery<ImportReference> importQuery = ToMergeImported.getImportPerMergePreparedQuery();
                CloseableWrappedIterable importIterator = null;
                for (MergeReference merge : mergeIterator) {
                    if (!merge.getState().equals((Object)ExecutionState.NEW) || !mergeState.equals((Object)ExecutionState.READY)) continue;
                    try {
                        try {
                            boolean ready = true;
                            importQuery.setArgumentHolderValue(0, (Object)merge);
                            importIterator = ServiceContext.getContext().getImportDao().getWrappedIterable(importQuery);
                            for (ImportReference importRef : importIterator) {
                                if (importRef.getState().equals((Object)ExecutionState.COMPLETED)) continue;
                                ready = false;
                                break;
                            }
                            if (!ready) continue;
                            merge.updateStatus(mergeState);
                        }
                        catch (Exception e) {
                            merge.updateStatus(ExecutionState.ERROR);
                            throw e;
                        }
                    }
                    finally {
                        if (importIterator != null) {
                            importIterator.close();
                        }
                    }
                }
            }
            finally {
                if (mergeIterator != null) {
                    mergeIterator.close();
                }
            }
        }
    }

    public static class ImportRequest
    extends ExecutionReference.ExecutionRequest {
        private String toReadStream;
        private ImportType type;

        public ImportRequest(GCUBEScope scope, String author, String toReadStream, ImportType type) {
            super(scope, author);
            this.toReadStream = toReadStream;
            this.type = type;
        }

        public String getToReadStream() {
            return this.toReadStream;
        }

        public ImportType getType() {
            return this.type;
        }
    }
}

