package org.gcube.data.harmonization.occurrence.operating;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/**
	 * Uses java.util.concurrent.Executors.defaultThreadFactory() setting threadLabel and priority (optional)
	 * 
	 * @author fabio
	 *
	 */
	

public	class MyThreadFactory implements ThreadFactory{
		
		private String label;
		private int priority;
		private boolean setPriority;
		private int index=0;
		
		public MyThreadFactory(String threadLabel,int priority) {
			super();			
			this.label=threadLabel;
			this.priority=priority;
			setPriority=true;
		}
		public MyThreadFactory(String threadLabel){
			super();
			this.label=threadLabel;
			setPriority=false;
		}
		
		@Override
		public Thread newThread(Runnable arg0) {			
			Thread toReturn=Executors.defaultThreadFactory().newThread(arg0);
//			toReturn.setName(ServiceUtils.generateId(label, ""));
			toReturn.setName(label+index);
			index++;
			if(setPriority)toReturn.setPriority(priority);
			return toReturn;
		}
	}