/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin;

import org.gcube.data.figis.tmplugin.FigisSource;
import org.gcube.data.figis.tmplugin.repository.Repository;
import org.gcube.data.figis.tmplugin.repository.Summary;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.exceptions.InvalidTreeException;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.tmf.impl.AbstractReader;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigisReader
extends AbstractReader {
    private static final long serialVersionUID = -3638289705441179714L;
    private static Logger log = LoggerFactory.getLogger(FigisReader.class);
    private final FigisSource source;
    private final Repository repository;

    public FigisReader(FigisSource source, Repository repository) {
        this.source = source;
        this.repository = repository;
    }

    public Tree get(String id, Pattern pattern) throws UnknownTreeException, InvalidTreeException, Exception {
        log.info("retrieving tree {} after pruning it with {}", (Object)id, (Object)this.source.id());
        Tree tree = null;
        try {
            tree = this.repository.get(id);
        }
        catch (Exception e) {
            throw new UnknownTreeException((Throwable)e);
        }
        return this.prune(tree, pattern);
    }

    private Tree prune(Tree tree, Pattern pattern) throws InvalidTreeException {
        try {
            pattern.prune((Node)tree);
        }
        catch (Exception e) {
            throw new InvalidTreeException((Throwable)e);
        }
        return Nodes.t((String)this.source.id(), (String)tree.id(), (Edge[])tree.edges().toArray(new Edge[0]));
    }

    public Stream<Tree> get(final Pattern pattern) throws Exception {
        log.info("retrieving trees from {} after pruning them with {}", (Object)this.source.id(), (Object)pattern);
        Generator<Tree, Tree> pruner = new Generator<Tree, Tree>(){

            public Tree yield(Tree tree) {
                try {
                    return FigisReader.this.prune(tree, pattern);
                }
                catch (InvalidTreeException e) {
                    log.warn("error retrieving trees", (Throwable)e);
                    return tree;
                }
            }
        };
        Stream<Tree> trees = this.repository.getRecords();
        return Streams.pipe(trees).through((Generator)pruner);
    }

    public Summary summary() throws Exception {
        return this.repository.summary();
    }
}

