package org.gcube.data.figis.tmplugin.repository;

import java.io.Serializable;

import org.gcube.data.streams.Stream;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Tree;

/**
 * A local interface to a remote OAI repository.
 *
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
public interface Repository extends Serializable {

	/**
	 * Returns the name of the repository.
	 * 
	 * @return the name
	 */
	String name();

	/**
	 * Returns the description of the repository.
	 * 
	 * @return the description
	 */
	String description();


	/**
	 * Retrieves a {@link Tree} with a given identifier 
	 * 
	 * @param id
	 *            the identifier
	 * @return the tree
	 * @throws UnknownTreeException
	 *             if there is no tree in the sets with the given identifier
	 * @throws Exception
	 *             if the operation fails for any other error
	 */
	Tree get(String id) throws UnknownTreeException, Exception;

	
	/**
	 * Retrieves all trees
	 * 
	 * @return the trees
	 * @throws Exception 
	 * @throws UnknownTreeException 
	 */
	Stream<Tree> getRecords() throws UnknownTreeException, Exception;
	
	
	/**
	 * Returns a {@link Summary} of a number of sets of the repository.
	 * 
	 * @param sets
	 *            the sets
	 * @return the summary
	 * @throws Exception
	 *             if the summary cannot be returned
	 */
	Summary summary() throws Exception;


}