/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.streaming;

import com.terradue.wps_hadoop.streaming.ExecutionResultsInfo;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class StreamingOutputUtils {
    private static Logger LOGGER = Logger.getLogger(StreamingOutputUtils.class);

    public static ResultsInfo copyAndGetResultFiles(ResultsInfo results, boolean withInputData, WpsHadoopConfiguration configuration) throws IOException {
        String wpsLocation = configuration.getWpsLocation();
        String jobId = results.getJobId();
        String outDir = configuration.getPathResolver().getOutputFilesPath(jobId);
        String destFolder = wpsLocation + outDir;
        String urlBase = configuration.getUrlBase();
        Path filesPath = new Path(outDir);
        FileSystem fs = FileSystem.get((Configuration)configuration);
        int i = 0;
        List<Path> attemptFolders = StreamingOutputUtils.getFolders(fs, filesPath);
        for (Path attemptFolder : attemptFolders) {
            List<Path> executionFolders = StreamingOutputUtils.getFolders(fs, attemptFolder);
            for (Path executionFolder : executionFolders) {
                String execFolder = "exec" + i + "/";
                String absoluteExecFolder = destFolder + execFolder;
                LOGGER.info((Object)("Copying files from directory " + executionFolder.getName() + " to the local folder " + absoluteExecFolder));
                FileStatus[] files = fs.listStatus(executionFolder);
                ExecutionResultsInfo executionResults = new ExecutionResultsInfo();
                for (FileStatus file : files) {
                    String fileName = file.getPath().getName();
                    boolean isInputDataFile = fileName.endsWith(configuration.getInputDataFileName());
                    if (!withInputData && isInputDataFile) continue;
                    Path absoluteFileLocalPath = new Path(absoluteExecFolder + fileName);
                    fs.copyToLocalFile(file.getPath(), absoluteFileLocalPath);
                    String url_href = urlBase + outDir + execFolder + fileName;
                    if (isInputDataFile) {
                        executionResults.setInputDataUrl(url_href);
                        continue;
                    }
                    executionResults.addOutputUrl(url_href);
                }
                results.addExecutionResults(executionResults);
                ++i;
            }
        }
        return results;
    }

    public static List<Path> copyFilesToLocalFolder(String jobId, boolean withInputData, WpsHadoopConfiguration configuration) throws IOException {
        String wpsLocation = configuration.getWpsLocation();
        return StreamingOutputUtils.copyFilesToLocalFolder(jobId, wpsLocation, withInputData, configuration);
    }

    public static List<Path> copyFilesToLocalFolder(String jobId, String destFolder, boolean withInputData, WpsHadoopConfiguration configuration) throws IOException {
        ArrayList<Path> finalPaths = new ArrayList<Path>();
        String outDir = configuration.getPathResolver().getOutputFilesPath(jobId);
        destFolder = destFolder + outDir;
        Path filesPath = new Path(outDir);
        FileSystem fs = FileSystem.get((Configuration)configuration);
        int i = 0;
        for (Path attemptFolder : StreamingOutputUtils.getFolders(fs, filesPath)) {
            for (Path executionFolder : StreamingOutputUtils.getFolders(fs, attemptFolder)) {
                FileStatus[] files;
                String execFolder = "exec" + i + "/";
                String absoluteExecFolder = destFolder + execFolder;
                LOGGER.info((Object)("Copying files from directory " + executionFolder.getName() + " to the local folder " + absoluteExecFolder));
                for (FileStatus file : files = fs.listStatus(executionFolder)) {
                    String fileName = file.getPath().getName();
                    if (!withInputData && fileName.endsWith(configuration.getInputDataFileName())) continue;
                    Path absoluteFileLocalPath = new Path(absoluteExecFolder + fileName);
                    fs.copyToLocalFile(file.getPath(), absoluteFileLocalPath);
                    finalPaths.add(new Path(outDir + execFolder + fileName));
                }
                ++i;
            }
        }
        return finalPaths;
    }

    private static List<Path> getFolders(FileSystem fs, Path path) throws IOException {
        FileStatus[] listStatus;
        ArrayList<Path> subPaths = new ArrayList<Path>();
        for (FileStatus status : listStatus = fs.listStatus(path)) {
            if (!status.isDir()) continue;
            subPaths.add(status.getPath());
        }
        return subPaths;
    }
}

