/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.streaming;

import com.terradue.wps_hadoop.streaming.UpdateHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.wps.x100.CRSsType;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.LiteralInputType;
import net.opengis.wps.x100.LiteralOutputType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import net.opengis.wps.x100.SupportedCRSsType;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import net.opengis.wps.x100.SupportedComplexDataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.IParser;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractAlgorithm;
import org.n52.wps.server.AbstractSelfDescribingAlgorithm;

public abstract class StreamingAbstractAlgorithm
extends AbstractSelfDescribingAlgorithm
implements UpdateHandler {
    protected final Logger logger = Logger.getLogger(AbstractAlgorithm.class);
    protected Configuration hadoopConfig = new Configuration();
    protected FileSystem hdfs = null;
    protected String hdfsPrefix;
    protected Object lastState = null;

    protected ProcessDescriptionType initializeDescription() {
        String className = this.getClass().getName().replace(".", "/");
        InputStream xmlDesc = this.getClass().getResourceAsStream("/" + className + ".xml");
        try {
            XmlOptions option = new XmlOptions();
            option.setLoadTrimTextBuffer();
            ProcessDescriptionsDocument doc = ProcessDescriptionsDocument.Factory.parse((InputStream)xmlDesc, (XmlOptions)option);
            if (doc.getProcessDescriptions().getProcessDescriptionArray().length == 0) {
                return null;
            }
            if (!doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(this.getClass().getName()) && !doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(this.getWellKnownName())) {
                doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().setStringValue(this.getClass().getName());
                System.out.println("Identifier was not correct, was changed now temporary for server use to " + this.getClass().getName() + ". Please change it later in the description!");
            }
            return doc.getProcessDescriptions().getProcessDescriptionArray(0);
        }
        catch (IOException e) {
            System.out.println("Could not initialize algorithm, parsing error: " + this.getClass().getName());
        }
        catch (XmlException e) {
            System.out.println("Could not initialize algorithm, parsing error: " + this.getClass().getName());
        }
        return this.SelfInitializeDescription();
    }

    protected ProcessDescriptionType SelfInitializeDescription() {
        ProcessDescriptionsDocument document = ProcessDescriptionsDocument.Factory.newInstance();
        ProcessDescriptionsDocument.ProcessDescriptions processDescriptions = document.addNewProcessDescriptions();
        ProcessDescriptionType processDescription = processDescriptions.addNewProcessDescription();
        processDescription.setStatusSupported(true);
        processDescription.setStoreSupported(true);
        processDescription.setProcessVersion("1.0.0");
        processDescription.addNewIdentifier().setStringValue(this.getClass().getName());
        processDescription.addNewTitle().setStringValue(this.getClass().getCanonicalName());
        List<String> identifiers = this.getInputIdentifiers();
        ProcessDescriptionType.DataInputs dataInputs = null;
        if (identifiers.size() > 0) {
            dataInputs = processDescription.addNewDataInputs();
        }
        for (String identifier : identifiers) {
            Class<?>[] interfaces;
            InputDescriptionType dataInput = dataInputs.addNewInput();
            dataInput.setMinOccurs(this.getMinOccurs(identifier));
            dataInput.setMaxOccurs(this.getMaxOccurs(identifier));
            dataInput.addNewIdentifier().setStringValue(identifier);
            dataInput.addNewTitle().setStringValue(identifier);
            Class inputDataTypeClass = this.getInputDataType(identifier);
            for (Class<?> implementedInterface : interfaces = inputDataTypeClass.getInterfaces()) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralInputType literalData = dataInput.addNewLiteralData();
                    String inputClassType = "";
                    for (Constructor<?> constructor : constructors = inputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        inputClassType = parameters[0].getSimpleName();
                    }
                    if (inputClassType.length() <= 0) continue;
                    DomainMetadataType datatype = literalData.addNewDataType();
                    datatype.setReference("xs:" + inputClassType.toLowerCase());
                    literalData.addNewAnyValue();
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataInput.addNewBoundingBoxData();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXInput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataInputType complexData = dataInput.addNewComplexData();
                List parsers = ParserFactory.getInstance().getAllParsers();
                ArrayList<IParser> foundParsers = new ArrayList<IParser>();
                for (IParser parser : parsers) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = parser.getSupportedDataBindings()) {
                        if (!clazz.equals(inputDataTypeClass)) continue;
                        foundParsers.add(parser);
                    }
                }
            }
        }
        ProcessDescriptionType.ProcessOutputs dataOutputs = processDescription.addNewProcessOutputs();
        List<String> outputIdentifiers = this.getOutputIdentifiers();
        for (String identifier : outputIdentifiers) {
            Class<?>[] interfaces;
            OutputDescriptionType dataOutput = dataOutputs.addNewOutput();
            dataOutput.addNewIdentifier().setStringValue(identifier);
            dataOutput.addNewTitle().setStringValue(identifier);
            dataOutput.addNewAbstract().setStringValue(identifier);
            Class outputDataTypeClass = this.getOutputDataType(identifier);
            for (Class<?> implementedInterface : interfaces = outputDataTypeClass.getInterfaces()) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralOutputType literalData = dataOutput.addNewLiteralOutput();
                    String outputClassType = "";
                    for (Constructor<?> constructor : constructors = outputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        outputClassType = parameters[0].getSimpleName();
                    }
                    if (outputClassType.length() <= 0) continue;
                    literalData.addNewDataType().setReference("xs:" + outputClassType.toLowerCase());
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataOutput.addNewBoundingBoxOutput();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXOutput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataType complexData = dataOutput.addNewComplexOutput();
                List generators = GeneratorFactory.getInstance().getAllGenerators();
                ArrayList<IGenerator> foundGenerators = new ArrayList<IGenerator>();
                for (IGenerator generator : generators) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = generator.getSupportedDataBindings()) {
                        if (!clazz.equals(outputDataTypeClass)) continue;
                        foundGenerators.add(generator);
                    }
                }
            }
        }
        return document.getProcessDescriptions().getProcessDescriptionArray(0);
    }

    public void update(Object state) {
        if (this.lastState == null || !this.lastState.toString().contentEquals(state.toString())) {
            super.update(state);
            this.lastState = state;
        }
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return null;
    }

    public List<String> getInputIdentifiers() {
        return null;
    }

    public List<String> getOutputIdentifiers() {
        return null;
    }

    @Override
    public void triggerUpdate(String percent) {
        this.update(percent);
    }
}

