/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.resampler;

import com.terradue.wps_hadoop.common.GeoTiffResampler;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Logger;

public class ResamplerMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(ResamplerMapper.class);

    public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
        String line = value.toString();
        LOGGER.info((Object)("Line = " + line));
        String[] values = line.split(" ");
        for (int i = 0; i < values.length; i += 3) {
            String wcs_url = values[i];
            LOGGER.info((Object)("wcs url = " + wcs_url));
            String outputPath = values[i + 1];
            LOGGER.info((Object)("Output dir " + outputPath));
            Double resolution = new Double(values[i + 2]);
            LOGGER.info((Object)("resolution = " + resolution));
            String resTifPath = GeoTiffResampler.resampleToTif(wcs_url, resolution, outputPath).toString();
            output.collect((Object)key, (Object)new Text(resTifPath));
        }
    }
}

