/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.hello_world;

import com.terradue.wps_hadoop.common.input.InputUtils;
import com.terradue.wps_hadoop.common.input.ListInputResource;
import com.terradue.wps_hadoop.streaming.Parameter;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.StreamingAbstractAlgorithm;
import com.terradue.wps_hadoop.streaming.StreamingPackagedAlgorithm;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class HelloWorld
extends StreamingAbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private List<String> errors = new ArrayList<String>();

    public Map<String, IData> run(Map<String, List<IData>> inputData) {
        List<String> names = InputUtils.getListStringInputParameter(inputData, "names", true);
        Integer a = InputUtils.getIntegerInputParameter(inputData, "a", true);
        Integer b = InputUtils.getIntegerInputParameter(inputData, "b", true);
        HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
        this.logger.info((Object)"Running Job HELLO WORLD...");
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        StreamingPackagedAlgorithm streaming = new StreamingPackagedAlgorithm(conf);
        streaming.setAlgorithmName("helloWorld");
        streaming.setInputResource(new ListInputResource(names));
        streaming.addFixedParameters(new Parameter("a", a), new Parameter("b", b), new Parameter("pi", Math.PI));
        streaming.setDebugMode(true);
        try {
            ResultsInfo result = streaming.runAsync(this);
            wpsResultMap.put("result", (IData)result.getXmlFileDataBinding());
            return wpsResultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Execution job failed! " + e.getMessage());
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public Class<?> getInputDataType(String id) {
        if (id.contentEquals("a")) {
            return LiteralIntBinding.class;
        }
        if (id.contentEquals("b")) {
            return LiteralIntBinding.class;
        }
        return LiteralStringBinding.class;
    }

    @Override
    public Class<?> getOutputDataType(String id) {
        if (id.contentEquals("result")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

