/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client;

import com.terradue.jcatalogue.client.Catalogue;
import com.terradue.jcatalogue.client.CatalogueClient;
import com.terradue.jcatalogue.client.CatalogueEntity;
import com.terradue.jcatalogue.client.OpenSearchUrl;
import com.terradue.jcatalogue.client.Parameter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class CatalogueDescription
extends CatalogueEntity {
    private final Map<String, OpenSearchUrl> typeUrlTemplates = new HashMap<String, OpenSearchUrl>();
    private String shortName;
    private String longName;
    private String description;
    private String[] tags;
    private String contact;
    private String developer;
    private String attribution;
    private String syndicationRight;
    private boolean adultContent;
    private Locale language;
    private Charset inputEncoding;
    private Charset outputEncoding;

    public void addOpenSearchUrl(OpenSearchUrl url) {
        this.typeUrlTemplates.put(url.getType(), url);
    }

    public Iterable<OpenSearchUrl> getOpenSearchUrls() {
        return this.typeUrlTemplates.values();
    }

    @Override
    void setCatalogueClient(CatalogueClient catalogueClient) {
        super.setCatalogueClient(catalogueClient);
        for (OpenSearchUrl url : this.typeUrlTemplates.values()) {
            url.setCatalogueClient(catalogueClient);
        }
    }

    public Catalogue getCatalogue(Parameter ... parameters) {
        if (!this.typeUrlTemplates.containsKey("application/atom+xml")) {
            throw new IllegalStateException("Direct URL invocation supports application/atom+xml only");
        }
        return this.typeUrlTemplates.get("application/atom+xml").invoke(parameters);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String getContact() {
        return this.contact;
    }

    public String getDeveloper() {
        return this.developer;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public String getSyndicationRight() {
        return this.syndicationRight;
    }

    public boolean isAdultContent() {
        return this.adultContent;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public Charset getInputEncoding() {
        return this.inputEncoding;
    }

    public Charset getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setDeveloper(String developer) {
        this.developer = developer;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public void setSyndicationRight(String syndicationRight) {
        this.syndicationRight = syndicationRight;
    }

    public void setAdultContent(boolean adultContent) {
        this.adultContent = adultContent;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public void setInputEncoding(Charset inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setOutputEncoding(Charset outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String toString() {
        return "CatalogueDescription(typeUrlTemplates=" + this.typeUrlTemplates + ", shortName=" + this.getShortName() + ", longName=" + this.getLongName() + ", description=" + this.getDescription() + ", tags=" + Arrays.deepToString(this.getTags()) + ", contact=" + this.getContact() + ", developer=" + this.getDeveloper() + ", attribution=" + this.getAttribution() + ", syndicationRight=" + this.getSyndicationRight() + ", adultContent=" + this.isAdultContent() + ", language=" + this.getLanguage() + ", inputEncoding=" + this.getInputEncoding() + ", outputEncoding=" + this.getOutputEncoding() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogueDescription)) {
            return false;
        }
        CatalogueDescription other = (CatalogueDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.typeUrlTemplates == null ? other.typeUrlTemplates != null : !((Object)this.typeUrlTemplates).equals(other.typeUrlTemplates)) {
            return false;
        }
        if (this.getShortName() == null ? other.getShortName() != null : !this.getShortName().equals(other.getShortName())) {
            return false;
        }
        if (this.getLongName() == null ? other.getLongName() != null : !this.getLongName().equals(other.getLongName())) {
            return false;
        }
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTags(), other.getTags())) {
            return false;
        }
        if (this.getContact() == null ? other.getContact() != null : !this.getContact().equals(other.getContact())) {
            return false;
        }
        if (this.getDeveloper() == null ? other.getDeveloper() != null : !this.getDeveloper().equals(other.getDeveloper())) {
            return false;
        }
        if (this.getAttribution() == null ? other.getAttribution() != null : !this.getAttribution().equals(other.getAttribution())) {
            return false;
        }
        if (this.getSyndicationRight() == null ? other.getSyndicationRight() != null : !this.getSyndicationRight().equals(other.getSyndicationRight())) {
            return false;
        }
        if (this.isAdultContent() != other.isAdultContent()) {
            return false;
        }
        if (this.getLanguage() == null ? other.getLanguage() != null : !this.getLanguage().equals(other.getLanguage())) {
            return false;
        }
        if (this.getInputEncoding() == null ? other.getInputEncoding() != null : !this.getInputEncoding().equals(other.getInputEncoding())) {
            return false;
        }
        return !(this.getOutputEncoding() == null ? other.getOutputEncoding() != null : !this.getOutputEncoding().equals(other.getOutputEncoding()));
    }

    public boolean canEqual(Object other) {
        return other instanceof CatalogueDescription;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        result = result * 31 + (this.typeUrlTemplates == null ? 0 : ((Object)this.typeUrlTemplates).hashCode());
        result = result * 31 + (this.getShortName() == null ? 0 : this.getShortName().hashCode());
        result = result * 31 + (this.getLongName() == null ? 0 : this.getLongName().hashCode());
        result = result * 31 + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        result = result * 31 + Arrays.deepHashCode(this.getTags());
        result = result * 31 + (this.getContact() == null ? 0 : this.getContact().hashCode());
        result = result * 31 + (this.getDeveloper() == null ? 0 : this.getDeveloper().hashCode());
        result = result * 31 + (this.getAttribution() == null ? 0 : this.getAttribution().hashCode());
        result = result * 31 + (this.getSyndicationRight() == null ? 0 : this.getSyndicationRight().hashCode());
        result = result * 31 + (this.isAdultContent() ? 1231 : 1237);
        result = result * 31 + (this.getLanguage() == null ? 0 : this.getLanguage().hashCode());
        result = result * 31 + (this.getInputEncoding() == null ? 0 : this.getInputEncoding().hashCode());
        result = result * 31 + (this.getOutputEncoding() == null ? 0 : this.getOutputEncoding().hashCode());
        return result;
    }
}

