/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.streaming;

import com.terradue.wps_hadoop.common.input.InputResource;
import com.terradue.wps_hadoop.common.input.ListInputResource;
import com.terradue.wps_hadoop.streaming.Hadoop_Streaming;
import com.terradue.wps_hadoop.streaming.Parameter;
import com.terradue.wps_hadoop.streaming.PathResolver;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.StreamingOutputUtils;
import com.terradue.wps_hadoop.streaming.UpdateHandler;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class StreamingPackagedAlgorithm {
    private static Logger LOGGER = Logger.getLogger(StreamingPackagedAlgorithm.class);
    private WpsHadoopConfiguration configuration;
    private String algorithmName;
    private File algorithmPackage;
    private List<Parameter> fixedParameters = new ArrayList<Parameter>();
    private String jobName;
    private boolean forceUpdateAlgorithmPackage = false;
    private InputResource inputResource;
    private boolean exportInputData = true;
    private boolean debugMode = false;
    private FileSystem fileSystem;
    private boolean copyFilesAfterExecution = true;

    public StreamingPackagedAlgorithm(WpsHadoopConfiguration configuration) {
        this.configuration = configuration;
    }

    public StreamingPackagedAlgorithm(WpsHadoopConfiguration configuration, String algorithmName) {
        this(configuration);
        this.algorithmName = algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void addFixedParameter(String name, String value) {
        this.fixedParameters.add(new Parameter(name, value));
    }

    public void addFixedParameter(String name, int value) {
        this.fixedParameters.add(new Parameter(name, value));
    }

    public void addFixedParameter(String name, float value) {
        this.fixedParameters.add(new Parameter(name, value));
    }

    public void addFixedParameter(String name, double value) {
        this.fixedParameters.add(new Parameter(name, value));
    }

    public void addFixedParameter(String name, boolean value) {
        this.fixedParameters.add(new Parameter(name, value));
    }

    public void addFixedParameter(Parameter p) {
        this.fixedParameters.add(p);
    }

    public void addFixedParameters(Parameter ... parameters) {
        for (Parameter p : parameters) {
            this.addFixedParameter(p);
        }
    }

    public void setExportInputData(boolean exportInputData) {
        this.exportInputData = exportInputData;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setForceUpdateAlgorithmPackage(boolean forceUpdateAlgorithmPackage) {
        this.forceUpdateAlgorithmPackage = forceUpdateAlgorithmPackage;
    }

    public void setAlgorithmPackage(File algorithmPackage) {
        this.algorithmPackage = algorithmPackage;
    }

    public void setAlgorithmPackage(File algorithmPackage, boolean forceUpdate) {
        this.algorithmPackage = algorithmPackage;
        this.forceUpdateAlgorithmPackage = forceUpdate;
    }

    public void setInputResource(InputResource inputResource) {
        this.inputResource = inputResource;
    }

    public InputResource getInputResource() {
        return this.inputResource;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setCopyFilesAfterExecution(boolean copyFilesAfterExecution) {
        this.copyFilesAfterExecution = copyFilesAfterExecution;
    }

    public ResultsInfo runSync() throws Exception {
        return this.run(null);
    }

    public ResultsInfo runAsync(UpdateHandler updateHandler) throws Exception {
        return this.run(updateHandler);
    }

    public ResultsInfo run(UpdateHandler updateHandler) throws Exception {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        PathResolver pathResolver = this.configuration.getPathResolver();
        String jobId = this.getJobId();
        String archivePath = this.getArchivePath();
        params.add(new Parameter("-archives", archivePath));
        String inputPath = pathResolver.getInputPath(jobId);
        this.createInputFile(inputPath);
        params.add(new Parameter("-input", inputPath));
        String outDir = pathResolver.getOutputPath(jobId);
        params.add(new Parameter("-output", outDir));
        String mapperPath = pathResolver.getStreamingMapperPath(this.algorithmName);
        String runnerFileSh = this.configuration.getRunnerFileSh();
        String mapperParam = (this.isDebugMode() ? "bash -x " : "") + mapperPath + runnerFileSh;
        params.add(new Parameter("-mapper", mapperParam));
        for (Parameter p : this.fixedParameters) {
            params.add(new Parameter("-cmdenv", p.toString()));
        }
        Parameter appPathPar = new Parameter("-cmdenv", "applicationPath=" + pathResolver.getAppPath(this.algorithmName));
        params.add(appPathPar);
        Parameter outputFilesPath = new Parameter("-cmdenv", "outputFilesPath=" + pathResolver.getOutputFilesPathStreaming(jobId));
        params.add(outputFilesPath);
        String[] arguments = this.convertMapToArgs(params);
        LOGGER.info((Object)("Params: \n" + ((Object)params).toString()));
        ResultsInfo resultsInfo = new ResultsInfo(this.configuration, jobId, this.algorithmName);
        int errorCode = Hadoop_Streaming.doRun(this.configuration, arguments, updateHandler);
        if (this.copyFilesAfterExecution) {
            resultsInfo = StreamingOutputUtils.copyAndGetResultFiles(resultsInfo, this.exportInputData, this.configuration);
        }
        this.cleanResultsOutput(outDir);
        return resultsInfo;
    }

    private void cleanResultsOutput(String outDir) {
    }

    private void createInputFile(String inputPath) throws IOException {
        FileSystem fs = this.getHdfs();
        FSDataOutputStream stream = fs.create(new Path(inputPath + "/inputFile"), true);
        this.inputResource.writeToStream((DataOutputStream)stream);
        stream.flush();
        stream.close();
    }

    private FileSystem getHdfs() throws IOException {
        if (this.fileSystem == null) {
            this.fileSystem = FileSystem.get((Configuration)this.configuration);
        }
        return this.fileSystem;
    }

    private String getJobId() {
        String jobId = this.jobName == null ? UUID.randomUUID().toString() : this.jobName;
        return jobId;
    }

    private String[] convertMapToArgs(List<Parameter> params) {
        int n = params.size();
        String[] args = new String[2 * n];
        int i = 0;
        for (Parameter p : params) {
            args[i++] = p.getName();
            args[i++] = p.getValue();
        }
        return args;
    }

    private String getArchivePath() throws IOException {
        String archivePath = this.configuration.getAlgorithmRepositoryPath() + this.algorithmName + ".jar";
        Path path = new Path(archivePath);
        LOGGER.info((Object)("archivePath=" + archivePath));
        FileSystem fs = this.getHdfs();
        boolean existsAlgorithm = fs.exists(path);
        if (!existsAlgorithm) {
            LOGGER.info((Object)("archivePath \"" + archivePath + "\" doesn't exists on the repository."));
        }
        if (this.forceUpdateAlgorithmPackage || !existsAlgorithm) {
            if (this.algorithmPackage != null) {
                String localAlgAbsPath = this.algorithmPackage.getAbsolutePath();
                LOGGER.info((Object)("uploading archive \"" + localAlgAbsPath + "\" to " + archivePath));
                Path filePath = new Path(localAlgAbsPath);
                fs.copyFromLocalFile(false, true, filePath, path);
                LOGGER.info((Object)("uploading archive \"" + localAlgAbsPath + "\" completed"));
            } else {
                throw new RuntimeException("Algorithm Package File not defined");
            }
        }
        return archivePath;
    }

    public static void main(String[] args) {
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        StreamingPackagedAlgorithm streaming = new StreamingPackagedAlgorithm(conf);
        streaming.setAlgorithmName("helloWorld");
        streaming.setInputResource(new ListInputResource("test", "ciccio", "pippo"));
        streaming.addFixedParameter("a", Math.PI);
        streaming.addFixedParameters(new Parameter("b", "5"), new Parameter("c", "6"));
        try {
            ResultsInfo results = streaming.runSync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

