/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;

public class CoordinateAxis1DTime
extends CoordinateAxis1D {
    private Date[] timeDates;
    private DateUnit dateUnit;

    public static CoordinateAxis1DTime factory(NetcdfDataset ncd, VariableDS org, Formatter errMessages) throws IOException {
        if (org.getDataType() == DataType.CHAR) {
            return new CoordinateAxis1DTime(ncd, org, errMessages, org.getDimension(0).getName());
        }
        return new CoordinateAxis1DTime(ncd, org, errMessages);
    }

    private CoordinateAxis1DTime(NetcdfDataset ncd, VariableDS org, Formatter errMessages, String dims) throws IOException {
        super(ncd, org.getParentGroup(), org.getShortName(), DataType.STRING, dims, org.getUnitsString(), org.getDescription());
        this.ncd = ncd;
        this.orgName = org.orgName;
        List<Attribute> atts = org.getAttributes();
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
        int ncoords = (int)org.getSize();
        int rank = org.getRank();
        int strlen = org.getShape(rank - 1);
        this.timeDates = new Date[ncoords /= strlen];
        ArrayChar data = (ArrayChar)org.read();
        ArrayChar.StringIterator ii = data.getStringIterator();
        ArrayObject.D1 sdata = new ArrayObject.D1(String.class, ncoords);
        for (int i = 0; i < ncoords; ++i) {
            String coordValue = ii.next();
            Date d = DateUnit.getStandardOrISO(coordValue);
            if (d == null) {
                if (errMessages != null) {
                    errMessages.format("DateUnit cannot parse String= %s\n", coordValue);
                } else {
                    System.out.println("DateUnit cannot parse String= " + coordValue + "\n");
                }
                throw new IllegalArgumentException();
            }
            sdata.set(i, coordValue);
            this.timeDates[i] = d;
        }
        this.setCachedData(sdata, true);
    }

    private CoordinateAxis1DTime(NetcdfDataset ncd, VariableDS org, Formatter errMessages) throws IOException {
        super(ncd, org);
        int ncoords = (int)org.getSize();
        this.timeDates = new Date[ncoords];
        DateUnit dateUnit = null;
        String units = org.getUnitsString();
        if (units != null) {
            try {
                dateUnit = new DateUnit(units);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (dateUnit != null) {
            Array data = org.read();
            int count = 0;
            IndexIterator ii = data.getIndexIterator();
            for (int i = 0; i < ncoords; ++i) {
                double val = ii.getDoubleNext();
                if (Double.isNaN(val)) continue;
                Date d = dateUnit.makeDate(val);
                this.timeDates[count++] = d;
            }
            if (count != ncoords) {
                Dimension localDim = new Dimension(this.getShortName(), count, false);
                this.setDimension(0, localDim);
                Array shortData = Array.factory(data.getElementType(), new int[]{count});
                Index ima = shortData.getIndex();
                int count2 = 0;
                ii = data.getIndexIterator();
                for (int i = 0; i < ncoords; ++i) {
                    double val = ii.getDoubleNext();
                    if (Double.isNaN(val)) continue;
                    shortData.setDouble(ima.set0(count2), val);
                    ++count2;
                }
                this.cache = new Variable.Cache();
                this.setCachedData(shortData, true);
                Date[] keep = this.timeDates;
                this.timeDates = new Date[count];
                System.arraycopy(keep, 0, this.timeDates, 0, this.timeDates.length);
            }
            return;
        }
        if (org.getDataType() == DataType.STRING) {
            ArrayObject data = (ArrayObject)org.read();
            IndexIterator ii = data.getIndexIterator();
            for (int i = 0; i < ncoords; ++i) {
                String coordValue = (String)ii.getObjectNext();
                Date d = DateUnit.getStandardOrISO(coordValue);
                if (d == null) {
                    if (errMessages != null) {
                        errMessages.format("DateUnit cannot parse String= %s\n", coordValue);
                    } else {
                        System.out.println("DateUnit cannot parse String= " + coordValue + "\n");
                    }
                    throw new IllegalArgumentException();
                }
                this.timeDates[i] = d;
            }
            return;
        }
        if (units != null) {
            try {
                dateUnit = new DateUnit(units + " since 0001-01-01 00:00:00");
            }
            catch (Exception e) {
                try {
                    if (errMessages != null) {
                        errMessages.format("Time Coordinate must be udunits or ISO String: hack since 0001-01-01 00:00:00\n", new Object[0]);
                    } else {
                        System.out.println("Time Coordinate must be udunits or ISO String: hack since 0001-01-01 00:00:00\n");
                    }
                    dateUnit = new DateUnit("secs since 0001-01-01 00:00:00");
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        Array data = org.read();
        IndexIterator ii = data.getIndexIterator();
        for (int i = 0; i < ncoords; ++i) {
            Date d;
            double val = ii.getDoubleNext();
            this.timeDates[i] = d = dateUnit.makeDate(val);
        }
    }

    private CoordinateAxis1DTime(NetcdfDataset ncd, CoordinateAxis1DTime org, Date[] timeDates) {
        super(ncd, org);
        this.timeDates = timeDates;
        this.dateUnit = org.dateUnit;
    }

    @Override
    protected Variable copy() {
        return new CoordinateAxis1DTime(this.ncd, this, this.getTimeDates());
    }

    public Date[] getTimeDates() {
        return this.timeDates;
    }

    public Date getTimeDate(int idx) {
        return this.timeDates[idx];
    }

    public DateRange getDateRange() {
        return new DateRange(this.timeDates[0], this.timeDates[this.timeDates.length - 1]);
    }

    @Override
    public List<NamedObject> getNames() {
        DateFormatter formatter = new DateFormatter();
        int n = (int)this.getSize();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(n);
        for (int i = 0; i < n; ++i) {
            names.add(new NamedAnything(formatter.toDateTimeString(this.getTimeDate(i)), "date/time"));
        }
        return names;
    }

    public TimeUnit getTimeResolution() throws Exception {
        String tUnits = this.getUnitsString();
        StringTokenizer stoker = new StringTokenizer(tUnits);
        double tResolution = this.getIncrement();
        return new TimeUnit(tResolution, stoker.nextToken());
    }

    public int findTimeIndexFromDate(Date d) {
        int index;
        int n = this.timeDates.length;
        long m = d.getTime();
        for (index = 0; index < n && m >= this.timeDates[index].getTime(); ++index) {
        }
        return Math.max(0, index - 1);
    }

    public boolean hasTime(Date date) {
        for (Date timeDate : this.timeDates) {
            if (!date.equals(timeDate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CoordinateAxis1D section(Range r) throws InvalidRangeException {
        CoordinateAxis1D s = super.section(r);
        Date[] d = new Date[r.length()];
        int i = r.first();
        int j = 0;
        while (i <= r.last()) {
            d[j] = this.timeDates[i];
            i += r.stride();
            ++j;
        }
        ((CoordinateAxis1DTime)s).timeDates = d;
        return s;
    }
}

