/*
 * Decompiled with CFR 0.152.
 */
package org.expressme.openid;

import java.text.SimpleDateFormat;

public final class Endpoint {
    static final String DEFAULT_ALIAS = "ext1";
    private final String url;
    private final String alias;
    private final long expired;

    public Endpoint(String url, String alias, long maxAgeInMilliSeconds) {
        if (url == null) {
            throw new NullPointerException("Url is null.");
        }
        this.url = url;
        this.alias = alias;
        this.expired = System.currentTimeMillis() + maxAgeInMilliSeconds;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expired;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            return ((Endpoint)o).url.equals(this.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Endpoint [uri:").append(this.url).append(", expired:").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.expired)).append(']');
        return sb.toString();
    }
}

